/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.events.CommandAction;
import mcjty.incontrol.events.EventType;
import mcjty.incontrol.events.EventTypeBlockBroken;
import mcjty.incontrol.events.EventTypeCustom;
import mcjty.incontrol.events.EventTypeMobKilled;
import mcjty.incontrol.events.EventsConditions;
import mcjty.incontrol.events.EventsParser;
import mcjty.incontrol.events.EventsRule;
import mcjty.incontrol.events.NumberAction;
import mcjty.incontrol.events.PhaseAction;
import mcjty.incontrol.events.SpawnEventAction;
import mcjty.incontrol.mob.DefaultMob;
import mcjty.incontrol.tools.rules.RuleBase;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class EventsSystem {
    private static final Map<EventType.Type, List<EventsRule>> rules = new HashMap<EventType.Type, List<EventsRule>>();
    private static final Map<ResourceLocation, List<EventsRule>> rulesByMob = new HashMap<ResourceLocation, List<EventsRule>>();
    private static final Random rnd = new Random();
    public static Mob busySpawning = null;
    private static Map<Level, List<ScheduledCustomEvent>> customEventMap = new HashMap<Level, List<ScheduledCustomEvent>>();

    public static void reloadRules() {
        customEventMap.clear();
        rules.clear();
        rulesByMob.clear();
        EventsParser.readRules("events.json");
    }

    public static void cleanup() {
        customEventMap.clear();
        rules.clear();
        rulesByMob.clear();
    }

    public static void addRule(EventsRule rule) {
        rules.computeIfAbsent(rule.getEventType().type(), k -> new ArrayList()).add(rule);
        EventType eventType = rule.getEventType();
        if (eventType instanceof EventTypeMobKilled) {
            EventTypeMobKilled mobKilled = (EventTypeMobKilled)eventType;
            for (ResourceLocation mob : mobKilled.getMobs()) {
                rulesByMob.computeIfAbsent(mob, k -> new ArrayList()).add(rule);
            }
        }
    }

    public static void onEntityKilled(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        List<EventsRule> eventsRules = rulesByMob.get(key);
        if (eventsRules != null) {
            for (EventsRule rule : eventsRules) {
                EventTypeMobKilled eventType = (EventTypeMobKilled)rule.getEventType();
                if (eventType.isPlayerKill() && !(event.getSource().getEntity() instanceof Player) || !EventsSystem.checkConditions(rule, entity.level())) continue;
                EventsSystem.doActions(rule, entity.blockPosition(), (ServerLevel)entity.level(), event.getSource().getEntity());
            }
        }
    }

    private static void doActions(EventsRule rule, BlockPos pos, ServerLevel level, @Nullable Entity player) {
        EventsSystem.doSpawnAction(rule, pos, level);
        EventsSystem.doPhaseAction(rule, (Level)level);
        EventsSystem.doNumberAction(rule, (Level)level);
        EventsSystem.doCommandAction(rule, pos, level, player);
    }

    private static void doCommandAction(EventsRule rule, BlockPos pos, ServerLevel level, @Nullable Entity player) {
        CommandAction action = rule.getCommandAction();
        if (action != null) {
            List<String> commands = action.commands();
            CommandSourceStack stack = new CommandSourceStack(RuleBase.EMPTY, Vec3.atCenterOf((Vec3i)pos), Vec2.ZERO, level, 2, RuleBase.DEFAULT_NAME.getString(), RuleBase.DEFAULT_NAME, level.getServer(), player);
            for (String command : commands) {
                level.getServer().getCommands().performPrefixedCommand(stack, command);
            }
        }
    }

    private static void doSpawnAction(EventsRule rule, BlockPos pos, ServerLevel level) {
        SpawnEventAction action = rule.getSpawnAction();
        if (action != null) {
            List<DefaultMob> mobs = action.mobid();
            DefaultMob mob = mobs.get(rnd.nextInt(mobs.size()));
            int count = action.minamount() + rnd.nextInt(action.maxamount() - action.minamount() + 1);
            for (int i = 0; i < count; ++i) {
                BlockPos randomPos;
                for (int a = 0; a < action.attempts() && !EventsSystem.spawn(mob, action, (ServerLevelAccessor)level, randomPos = EventsSystem.getRandomPos(pos, action.mindistance(), action.maxdistance())); ++a) {
                }
            }
        }
    }

    private static void doPhaseAction(EventsRule rule, Level level) {
        PhaseAction action = rule.getPhaseAction();
        if (action != null) {
            DataStorage data = DataStorage.getData((LevelAccessor)level);
            action.phases().forEach(p -> data.setPhase((String)p, action.set()));
        }
    }

    private static void doNumberAction(EventsRule rule, Level level) {
        NumberAction action = rule.getNumberAction();
        if (action != null) {
            DataStorage data = DataStorage.getData((LevelAccessor)level);
            int number = data.getNumber(action.name());
            data.setNumber(action.name(), action.perform(number));
        }
    }

    private static boolean checkConditions(EventsRule rule, Level level) {
        EventsConditions conditions = rule.getConditions();
        float random = conditions.getRandom();
        if (random >= 0.0f && rnd.nextFloat() >= random) {
            return false;
        }
        if (!EventsSystem.checkPhases(level, conditions)) {
            return false;
        }
        if (!EventsSystem.checkNumbers(level, conditions)) {
            return false;
        }
        Set<ResourceKey<Level>> dimensions = conditions.getDimensions();
        return dimensions.isEmpty() || dimensions.contains(level.dimension());
    }

    private static boolean checkNumbers(Level level, EventsConditions conditions) {
        if (!conditions.getNumbers().isEmpty()) {
            DataStorage data = DataStorage.getData((LevelAccessor)level);
            for (Map.Entry<String, Predicate<Integer>> entry : conditions.getNumbers().entrySet()) {
                int number = data.getNumber(entry.getKey());
                if (entry.getValue().test(number)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkPhases(Level level, EventsConditions conditions) {
        Set<String> phases;
        return conditions.getPhases().isEmpty() || (phases = DataStorage.getData((LevelAccessor)level).getPhases()).containsAll(conditions.getPhases());
    }

    private static BlockPos getRandomPos(BlockPos center, float mindistance, float maxdistance) {
        float distance = mindistance + rnd.nextFloat() * (maxdistance - mindistance);
        double angle = (double)rnd.nextFloat() * Math.PI * 2.0;
        int x = (int)((double)center.getX() + (double)distance * Math.cos(angle));
        int z = (int)((double)center.getZ() + (double)distance * Math.sin(angle));
        return new BlockPos(x, center.getY(), z);
    }

    private static boolean spawn(DefaultMob mob, SpawnEventAction action, ServerLevelAccessor world, BlockPos pos) {
        Entity entity = mob.getEntity(world.getLevel());
        if (entity == null) {
            return false;
        }
        Mob mobEntity = (Mob)entity;
        entity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), rnd.nextFloat() * 360.0f, 0.0f);
        busySpawning = mobEntity;
        if (EventsSystem.canSpawn((Level)world.getLevel(), mobEntity, action) && EventsSystem.isNotColliding((Level)world.getLevel(), mobEntity, action)) {
            EventHooks.finalizeMobSpawn((Mob)mobEntity, (ServerLevelAccessor)world, (DifficultyInstance)world.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.NATURAL, null);
            if (!((Mob)entity).isSpawnCancelled()) {
                world.addFreshEntityWithPassengers(entity);
                busySpawning = null;
                return true;
            }
        }
        busySpawning = null;
        return false;
    }

    private static boolean canSpawn(Level world, Mob mobEntity, SpawnEventAction action) {
        if (action.norestrictions()) {
            return true;
        }
        return EventHooks.checkSpawnPosition((Mob)mobEntity, (ServerLevelAccessor)((ServerLevelAccessor)world), (MobSpawnType)MobSpawnType.NATURAL);
    }

    private static boolean isNotColliding(Level world, Mob mobEntity, SpawnEventAction action) {
        return mobEntity.checkSpawnObstruction((LevelReader)world);
    }

    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        List<EventsRule> eventsRules = rules.get((Object)EventType.Type.BLOCK_BROKEN);
        if (eventsRules != null) {
            for (EventsRule rule : eventsRules) {
                EventTypeBlockBroken eventType = (EventTypeBlockBroken)rule.getEventType();
                if (!EventsSystem.checkConditions(rule, event.getPlayer().level()) || !eventType.getBlockTest().test(event.getLevel(), event.getPos())) continue;
                EventsSystem.doActions(rule, event.getPos(), (ServerLevel)event.getLevel(), (Entity)event.getPlayer());
            }
        }
    }

    public static void onLevelTick(LevelTickEvent.Pre event) {
        List<ScheduledCustomEvent> events = customEventMap.get(event.getLevel());
        if (events != null && !events.isEmpty()) {
            ArrayList<ScheduledCustomEvent> copy = new ArrayList<ScheduledCustomEvent>(events);
            events.clear();
            for (ScheduledCustomEvent scheduledCustomEvent : copy) {
                EventsSystem.handleCustomEvent((ServerLevel)event.getLevel(), scheduledCustomEvent.pos, scheduledCustomEvent.name);
            }
        }
    }

    public static void onCustomEvent(Level level, BlockPos pos, String name) {
        List events = customEventMap.computeIfAbsent(level, k -> new ArrayList());
        events.add(new ScheduledCustomEvent(pos, name));
    }

    private static void handleCustomEvent(ServerLevel level, BlockPos pos, String name) {
        List<EventsRule> eventsRules = rules.get((Object)EventType.Type.CUSTOM);
        if (eventsRules != null) {
            for (EventsRule rule : eventsRules) {
                EventTypeCustom eventType = (EventTypeCustom)rule.getEventType();
                if (!EventsSystem.checkConditions(rule, (Level)level) || !eventType.getName().equals(name)) continue;
                EventsSystem.doActions(rule, pos, level, null);
            }
        }
    }

    private record ScheduledCustomEvent(BlockPos pos, String name) {
    }
}

