/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network;

import glitchcore.network.CustomPacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import sereneseasons.season.SeasonHandlerClient;

public class SyncSeasonCyclePacket
implements CustomPacket<SyncSeasonCyclePacket> {
    public ResourceKey<Level> dimension;
    public int seasonCycleTicks;

    public SyncSeasonCyclePacket() {
    }

    public SyncSeasonCyclePacket(ResourceKey<Level> dimension, int seasonCycleTicks) {
        this.dimension = dimension;
        this.seasonCycleTicks = seasonCycleTicks;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.dimension.location().toString());
        buf.writeInt(this.seasonCycleTicks);
    }

    public SyncSeasonCyclePacket decode(FriendlyByteBuf buf) {
        return new SyncSeasonCyclePacket((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf())), buf.readInt());
    }

    public void handle(SyncSeasonCyclePacket packet, CustomPacket.Context context) {
        context.getPlayer().ifPresent(player -> {
            ResourceKey playerDimension = player.level().dimension();
            if (playerDimension.equals(packet.dimension)) {
                SeasonHandlerClient.clientSeasonCycleTicks.put((ResourceKey<Level>)playerDimension, packet.seasonCycleTicks);
            }
        });
    }
}

