/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.valarian_conquest.entity.MaleCitizenEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MaleCitizenRenderer
extends HumanoidMobRenderer<MaleCitizenEntity, HumanoidModel<MaleCitizenEntity>> {
    public MaleCitizenRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new MaleModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(MaleCitizenEntity entity) {
        int variant = Math.max(1, entity.getTextureVariant());
        return ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)("textures/entities/male_citizen_" + variant + ".png"));
    }

    private static final class MaleModel
    extends HumanoidModel<MaleCitizenEntity> {
        private final ModelPart root;
        private final ModelPart jacket;
        private final ModelPart leftSleeve;
        private final ModelPart rightSleeve;
        private final ModelPart leftPants;
        private final ModelPart rightPants;

        public MaleModel(ModelPart root) {
            super(root);
            this.root = root;
            this.jacket = root.getChild("jacket");
            this.leftSleeve = root.getChild("left_sleeve");
            this.rightSleeve = root.getChild("right_sleeve");
            this.leftPants = root.getChild("left_pants");
            this.rightPants = root.getChild("right_pants");
            this.jacket.visible = true;
            this.leftSleeve.visible = true;
            this.rightSleeve.visible = true;
            this.leftPants.visible = true;
            this.rightPants.visible = true;
        }

        public void setupAnim(MaleCitizenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.jacket.copyFrom(this.body);
            this.leftSleeve.copyFrom(this.leftArm);
            this.rightSleeve.copyFrom(this.rightArm);
            this.leftPants.copyFrom(this.leftLeg);
            this.rightPants.copyFrom(this.rightLeg);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
            this.jacket.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.leftSleeve.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.rightSleeve.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.leftPants.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.rightPants.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }
}

