/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.valarian_conquest.client.model.Modeltroll;
import net.mcreator.valarian_conquest.client.model.animations.trollAnimation;
import net.mcreator.valarian_conquest.entity.TrollEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class TrollRenderer
extends MobRenderer<TrollEntity, Modeltroll<TrollEntity>> {
    public TrollRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeltroll.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(TrollEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.5f, 1.5f, 1.5f);
    }

    public ResourceLocation getTextureLocation(TrollEntity entity) {
        return ResourceLocation.parse((String)"valarian_conquest:textures/entities/troll.png");
    }

    private static final class AnimatedModel
    extends Modeltroll<TrollEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<TrollEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(TrollEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, trollAnimation.idle, ageInTicks, 0.9f);
                this.animate(entity.animationState1, trollAnimation.walk, ageInTicks, 1.3f);
                this.animate(entity.animationState2, trollAnimation.swingattack, ageInTicks, 1.0f);
                this.animate(entity.animationState3, trollAnimation.throwrock, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(TrollEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

