/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mcreator.valarian_conquest.api.ISheatheable;
import net.mcreator.valarian_conquest.entity.SoldierEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BackItemsLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandLayer<T, M> vanillaHands;

    public BackItemsLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemRenderer) {
        super(parent);
        this.vanillaHands = new ItemInHandLayer(parent, itemRenderer);
    }

    public void render(PoseStack ps, MultiBufferSource buf, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Monster m;
        ISheatheable s;
        SoldierEntity soldier;
        if (entity instanceof SoldierEntity && !(soldier = (SoldierEntity)entity).isBackSheathe()) {
            return;
        }
        if (!(entity instanceof ISheatheable) || !(s = (ISheatheable)entity).shouldSheatheWeapons()) {
            this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        if (entity instanceof Monster && (m = (Monster)entity).isAggressive()) {
            this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        ItemStack main = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemStack off = entity.getItemBySlot(EquipmentSlot.OFFHAND);
        entity.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        entity.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        entity.setItemSlot(EquipmentSlot.MAINHAND, main);
        entity.setItemSlot(EquipmentSlot.OFFHAND, off);
        if (!off.isEmpty()) {
            ps.pushPose();
            ps.translate(-0.13, 0.2, 0.1);
            ps.mulPose(Axis.YP.rotationDegrees(270.0f));
            ps.mulPose(Axis.XP.rotationDegrees(180.0f));
            ps.scale(0.95f, 0.95f, 0.95f);
            Minecraft.getInstance().getItemRenderer().renderStatic(off, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, ps, buf, entity.level(), entity.getId());
            ps.popPose();
        }
        if (!main.isEmpty()) {
            ps.pushPose();
            ps.translate(-0.3, 0.1, 0.2);
            ps.mulPose(Axis.YP.rotationDegrees(90.0f));
            ps.mulPose(Axis.XP.rotationDegrees(45.0f));
            ps.scale(0.95f, 0.95f, 0.95f);
            Minecraft.getInstance().getItemRenderer().renderStatic(main, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, ps, buf, entity.level(), entity.getId());
            ps.popPose();
        }
    }
}

