/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mcreator.valarian_conquest.api.ISheatheable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SheathItemsLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandLayer<T, M> vanillaHands;

    public SheathItemsLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemRenderer) {
        super(parent);
        this.vanillaHands = new ItemInHandLayer(parent, itemRenderer);
    }

    public void render(PoseStack ps, MultiBufferSource buf, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Monster m;
        boolean aggressive;
        boolean bl = aggressive = entity instanceof Monster && (m = (Monster)entity).isAggressive();
        if (aggressive) {
            this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        if (!((ISheatheable)entity).shouldSheatheWeapons()) {
            this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        if (((ISheatheable)entity).isSideSheathe()) {
            this.renderSide(ps, buf, light, entity);
            return;
        }
        if (((ISheatheable)entity).isBackSheathe()) {
            this.renderBack(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    private void renderSide(PoseStack ps, MultiBufferSource buf, int light, T entity) {
        ItemStack main = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemStack off = entity.getItemBySlot(EquipmentSlot.OFFHAND);
        if (!off.isEmpty()) {
            ps.pushPose();
            ps.translate(-0.13, 0.2, 0.1);
            ps.mulPose(Axis.YP.rotationDegrees(270.0f));
            ps.mulPose(Axis.XP.rotationDegrees(180.0f));
            ps.scale(0.95f, 0.95f, 0.95f);
            Minecraft.getInstance().getItemRenderer().renderStatic(off, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, ps, buf, entity.level(), entity.getId());
            ps.popPose();
        }
        if (!main.isEmpty()) {
            ps.pushPose();
            ps.translate(0.28, 0.6, -0.2);
            ps.mulPose(Axis.XP.rotationDegrees(30.0f));
            ps.scale(1.1f, 0.85f, 0.85f);
            Minecraft.getInstance().getItemRenderer().renderStatic(main, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, ps, buf, entity.level(), entity.getId());
            ps.popPose();
        }
    }

    private void renderBack(PoseStack ps, MultiBufferSource buf, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack main = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemStack off = entity.getItemBySlot(EquipmentSlot.OFFHAND);
        entity.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        entity.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        this.vanillaHands.render(ps, buf, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        entity.setItemSlot(EquipmentSlot.MAINHAND, main);
        entity.setItemSlot(EquipmentSlot.OFFHAND, off);
        if (!off.isEmpty()) {
            ps.pushPose();
            ps.translate(-0.13, 0.2, 0.1);
            ps.mulPose(Axis.YP.rotationDegrees(270.0f));
            ps.mulPose(Axis.XP.rotationDegrees(180.0f));
            ps.scale(0.95f, 0.95f, 0.95f);
            Minecraft.getInstance().getItemRenderer().renderStatic(off, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, ps, buf, entity.level(), entity.getId());
            ps.popPose();
        }
        if (!main.isEmpty()) {
            ps.pushPose();
            ps.translate(-0.3, 0.1, 0.2);
            ps.mulPose(Axis.YP.rotationDegrees(90.0f));
            ps.mulPose(Axis.XP.rotationDegrees(45.0f));
            ps.scale(0.95f, 0.95f, 0.95f);
            Minecraft.getInstance().getItemRenderer().renderStatic(main, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.NO_OVERLAY, ps, buf, entity.level(), entity.getId());
            ps.popPose();
        }
    }
}

