/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.init.ValarianConquestModItems;
import net.mcreator.valarian_conquest.procedures.BallistaArrowHitsProcedureProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BallistaArrowProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)ValarianConquestModItems.BALLISTA_ARROW.get());

    public BallistaArrowProjectileEntity(EntityType<? extends BallistaArrowProjectileEntity> type, int x, int y, int z, Level world, ItemStack itemStack) {
        super(type, (double)x, (double)y, (double)z, world, PROJECTILE_ITEM, itemStack);
    }

    public BallistaArrowProjectileEntity(EntityType<? extends BallistaArrowProjectileEntity> type, Level world) {
        super(type, world);
    }

    public BallistaArrowProjectileEntity(EntityType<? extends BallistaArrowProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM, PROJECTILE_ITEM);
    }

    public BallistaArrowProjectileEntity(EntityType<? extends BallistaArrowProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        BallistaArrowHitsProcedureProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        BallistaArrowHitsProcedureProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
    }

    public boolean isNoGravity() {
        return true;
    }

    public void tick() {
        if (!this.inGround) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
        }
        super.tick();
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public static BallistaArrowProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return BallistaArrowProjectileEntity.shoot(world, entity, source, 2.0f, 25.0, 0);
    }

    public static BallistaArrowProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return BallistaArrowProjectileEntity.shoot(world, entity, source, pullingPower * 2.0f, 25.0, 0);
    }

    public static BallistaArrowProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BallistaArrowProjectileEntity entityarrow = new BallistaArrowProjectileEntity((EntityType<? extends BallistaArrowProjectileEntity>)((EntityType)ValarianConquestModEntities.BALLISTA_ARROW_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:ballista_launch")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static BallistaArrowProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        BallistaArrowProjectileEntity entityarrow = new BallistaArrowProjectileEntity((EntityType<? extends BallistaArrowProjectileEntity>)((EntityType)ValarianConquestModEntities.BALLISTA_ARROW_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 4.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(25.0);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:ballista_launch")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

