/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.init.ValarianConquestModItems;
import net.mcreator.valarian_conquest.procedures.CannonBallProjectileProjectileHitsBlockProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CatapultRockProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)ValarianConquestModItems.CATAPULT_ROCK.get());

    public CatapultRockProjectileEntity(EntityType<? extends CatapultRockProjectileEntity> type, int x, int y, int z, Level world, ItemStack itemStack) {
        super(type, (double)x, (double)y, (double)z, world, itemStack, itemStack);
    }

    public CatapultRockProjectileEntity(EntityType<? extends CatapultRockProjectileEntity> type, Level world) {
        super(type, world);
    }

    public CatapultRockProjectileEntity(EntityType<? extends CatapultRockProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM, PROJECTILE_ITEM);
    }

    public CatapultRockProjectileEntity(EntityType<? extends CatapultRockProjectileEntity> type, LivingEntity shooter, Level world) {
        super(type, shooter, world, PROJECTILE_ITEM, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    protected void onHitEntity(EntityHitResult hit) {
        super.onHitEntity(hit);
        CannonBallProjectileProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        CannonBallProjectileProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), hit.getBlockPos().getX(), hit.getBlockPos().getY(), hit.getBlockPos().getZ());
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static CatapultRockProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random) {
        return CatapultRockProjectileEntity.shoot(world, entity, random, 0.75f, 12.0, 3);
    }

    public static CatapultRockProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        CatapultRockProjectileEntity arrow = new CatapultRockProjectileEntity((EntityType<? extends CatapultRockProjectileEntity>)((EntityType)ValarianConquestModEntities.CATAPULT_ROCK_PROJECTILE.get()), entity, world);
        arrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        arrow.setSilent(true);
        arrow.setCritArrow(false);
        arrow.setBaseDamage(damage);
        world.addFreshEntity((Entity)arrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)world.registryAccess().registryOrThrow(Registries.SOUND_EVENT).get(ResourceLocation.parse((String)"valarian_conquest:catapult_fire")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return arrow;
    }
}

