/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.entity;

import javax.annotation.Nullable;
import net.mcreator.valarian_conquest.procedures.GateCloseAnimationProcedure;
import net.mcreator.valarian_conquest.procedures.GateDespawnProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.GateOpenAnimationProcedure;
import net.mcreator.valarian_conquest.procedures.GateSpawnOpenProcedureProcedure;
import net.mcreator.valarian_conquest.procedures.PlayerClicksGateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GateEntityEntity
extends Monster {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public GateEntityEntity(EntityType<GateEntityEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(true);
        this.setPersistenceRequired();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:iron_gate_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"valarian_conquest:iron_gate_break"));
    }

    public void die(DamageSource source) {
        super.die(source);
        GateDespawnProcedureProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        GateSpawnOpenProcedureProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getTeam() != null && player.getTeam() != null) {
            if (this.getTeam() != player.getTeam()) {
                return InteractionResult.FAIL;
            }
        } else {
            return InteractionResult.FAIL;
        }
        InteractionResult result = InteractionResult.SUCCESS;
        super.mobInteract(player, hand);
        PlayerClicksGateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        return result;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(GateOpenAnimationProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(GateCloseAnimationProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public boolean canCollideWith(Entity entity) {
        return !this.getPersistentData().getBoolean("gateopen");
    }

    public boolean canBeCollidedWith() {
        return !this.getPersistentData().getBoolean("gateopen");
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        this.hurtTime = 0;
        this.hurtDuration = 0;
        this.hurtMarked = false;
        return result;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
        builder = builder.add(Attributes.MAX_HEALTH, 120.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 100.0);
        return builder;
    }
}

