/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.init;

import net.mcreator.valarian_conquest.potion.CannonCooldownPotionMobEffect;
import net.mcreator.valarian_conquest.potion.GuardPotionMobEffect;
import net.mcreator.valarian_conquest.potion.LongPatrolPotionMobEffect;
import net.mcreator.valarian_conquest.potion.MoveToPlayerPotionMobEffect;
import net.mcreator.valarian_conquest.potion.NPCFollowPotionMobEffect;
import net.mcreator.valarian_conquest.potion.PatrolPointsPotionMobEffect;
import net.mcreator.valarian_conquest.potion.StandGroundPotionMobEffect;
import net.mcreator.valarian_conquest.potion.SummonHorseMountPotionMobEffect;
import net.mcreator.valarian_conquest.procedures.CatapultCooldownLogicProcedure;
import net.mcreator.valarian_conquest.procedures.SummonHorseMountProcedureProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class ValarianConquestModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"valarian_conquest");
    public static final DeferredHolder<MobEffect, MobEffect> CANNON_COOLDOWN_POTION = REGISTRY.register("cannon_cooldown_potion", () -> new CannonCooldownPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MOVE_TO_PLAYER_POTION = REGISTRY.register("move_to_player_potion", () -> new MoveToPlayerPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SUMMON_HORSE_MOUNT_POTION = REGISTRY.register("summon_horse_mount_potion", () -> new SummonHorseMountPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GUARD_POTION = REGISTRY.register("guard_potion", () -> new GuardPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STAND_GROUND_POTION = REGISTRY.register("stand_ground_potion", () -> new StandGroundPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PATROL_POINTS_POTION = REGISTRY.register("patrol_points_potion", () -> new PatrolPointsPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> NPC_FOLLOW_POTION = REGISTRY.register("npc_follow_potion", () -> new NPCFollowPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LONG_PATROL_POTION = REGISTRY.register("long_patrol_potion", () -> new LongPatrolPotionMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ValarianConquestModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ValarianConquestModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(CANNON_COOLDOWN_POTION)) {
            CatapultCooldownLogicProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(SUMMON_HORSE_MOUNT_POTION)) {
            SummonHorseMountProcedureProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

