/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.mcreator.valarian_conquest.init.ValarianConquestModVillagerProfessions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="valarian_conquest")
public class BarberSurgeonHealProcedure {
    private static final WeakHashMap<Entity, Integer> cooldownMap = new WeakHashMap();
    private static final WeakHashMap<Entity, LivingEntity> currentTargetMap = new WeakHashMap();

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        BarberSurgeonHealProcedure.execute(event.getEntity());
    }

    public static void execute(Entity entity) {
        BarberSurgeonHealProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Object event, Entity entity) {
        List nearby;
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (villager.getVillagerData().getProfession() != ValarianConquestModVillagerProfessions.BARBER_SURGEON_PROFESSION.get()) {
            return;
        }
        int ticks = cooldownMap.getOrDefault(entity, 0);
        if (ticks > 0) {
            cooldownMap.put(entity, ticks - 1);
            return;
        }
        cooldownMap.put(entity, 20);
        LivingEntity target = currentTargetMap.get(entity);
        if (target != null && (!target.isAlive() || target.getHealth() >= target.getMaxHealth() || target.distanceTo(entity) > 32.0f)) {
            currentTargetMap.remove(entity);
            target = null;
        }
        if (target == null && (target = (LivingEntity)(nearby = entity.level().getEntitiesOfClass(LivingEntity.class, new AABB(entity.blockPosition()).inflate(32.0), e -> e.isAlive() && e.getHealth() < e.getMaxHealth() && e != entity && e.isAlliedTo(entity))).stream().min(Comparator.comparingDouble(e -> e.distanceToSqr(entity))).orElse(null)) != null) {
            currentTargetMap.put(entity, target);
        }
        if (target == null) {
            return;
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            double distance = entity.distanceTo((Entity)target);
            if (distance > 2.5) {
                mob.getNavigation().moveTo((Entity)target, 0.75);
            } else {
                mob.getNavigation().stop();
                target.heal(2.0f);
                entity.level().addParticle((ParticleOptions)ParticleTypes.HEART, target.getX(), target.getY() + 1.75, target.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

