/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.mcreator.valarian_conquest.init.ValarianConquestModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class LongPatrolActiveProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        Path path;
        boolean isLeader;
        UUID leaderID;
        if (entity == null || !(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        if (mob.getTarget() != null && mob.getTarget().isAlive()) {
            return;
        }
        if (!entity.getPersistentData().contains("patrolLeader")) {
            entity.getPersistentData().putUUID("patrolLeader", entity.getUUID());
            entity.getPersistentData().putBoolean("isLeader", true);
            List nearby = level.getEntities(entity, mob.getBoundingBox().inflate(32.0));
            for (Entity e : nearby) {
                LivingEntity le;
                if (!(e instanceof LivingEntity) || !LongPatrolActiveProcedure.hasLongPatrolEffect(le = (LivingEntity)e) || e == mob) continue;
                e.getPersistentData().putUUID("patrolLeader", entity.getUUID());
                e.getPersistentData().putBoolean("isLeader", false);
            }
            leaderID = entity.getUUID();
        } else {
            leaderID = entity.getPersistentData().getUUID("patrolLeader");
        }
        Entity leader = level.getEntity(leaderID);
        if (leader == null || !leader.isAlive()) {
            entity.getPersistentData().putUUID("patrolLeader", entity.getUUID());
            entity.getPersistentData().putBoolean("isLeader", true);
            leader = entity;
        }
        if ((isLeader = entity.getPersistentData().getBoolean("isLeader")) && !leader.getPersistentData().getBoolean("hasPatrolTarget")) {
            Player nearestPlayer = level.getNearestPlayer(leader, 64.0);
            BlockPos startPos = nearestPlayer != null ? nearestPlayer.blockPosition() : leader.blockPosition();
            BlockPos firstTarget = LongPatrolActiveProcedure.findSafeRandomPos(level, startPos, 24, 32);
            leader.getPersistentData().putInt("patrolX", firstTarget.getX());
            leader.getPersistentData().putInt("patrolY", firstTarget.getY());
            leader.getPersistentData().putInt("patrolZ", firstTarget.getZ());
            leader.getPersistentData().putBoolean("hasPatrolTarget", true);
        }
        if (!isLeader && leader != null) {
            entity.getPersistentData().putInt("patrolX", leader.getPersistentData().getInt("patrolX"));
            entity.getPersistentData().putInt("patrolY", leader.getPersistentData().getInt("patrolY"));
            entity.getPersistentData().putInt("patrolZ", leader.getPersistentData().getInt("patrolZ"));
            entity.getPersistentData().putBoolean("hasPatrolTarget", true);
        }
        BlockPos patrolTarget = new BlockPos(entity.getPersistentData().getInt("patrolX"), entity.getPersistentData().getInt("patrolY"), entity.getPersistentData().getInt("patrolZ"));
        double distance = entity.position().distanceTo(Vec3.atCenterOf((Vec3i)patrolTarget));
        if (isLeader && distance < 3.5) {
            BlockPos newTarget = LongPatrolActiveProcedure.findSafeRandomPos(level, entity.blockPosition(), 96, 128);
            leader.getPersistentData().putInt("patrolX", newTarget.getX());
            leader.getPersistentData().putInt("patrolY", newTarget.getY());
            leader.getPersistentData().putInt("patrolZ", newTarget.getZ());
            leader.getPersistentData().putBoolean("hasPatrolTarget", true);
            List nearby = level.getEntities(leader, leader.getBoundingBox().inflate(64.0));
            for (Entity e : nearby) {
                if (!e.getPersistentData().hasUUID("patrolLeader") || !e.getPersistentData().getUUID("patrolLeader").equals(leader.getUUID()) || e == leader) continue;
                e.getPersistentData().putInt("patrolX", newTarget.getX());
                e.getPersistentData().putInt("patrolY", newTarget.getY());
                e.getPersistentData().putInt("patrolZ", newTarget.getZ());
            }
        }
        if (mob.getNavigation().isDone() && (path = mob.getNavigation().createPath(patrolTarget, 1)) != null) {
            mob.getNavigation().moveTo(path, 0.7);
        }
    }

    private static BlockPos findSafeRandomPos(ServerLevel level, BlockPos origin, int minDist, int maxDist) {
        for (int i = 0; i < 20; ++i) {
            BlockPos checkPos;
            int dx = level.random.nextIntBetweenInclusive(-maxDist, maxDist);
            int dz = level.random.nextIntBetweenInclusive(-maxDist, maxDist);
            if (Math.abs(dx) < minDist && Math.abs(dz) < minDist || !level.getBlockState(checkPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, origin.offset(dx, 0, dz))).getFluidState().isEmpty()) continue;
            return checkPos;
        }
        return origin;
    }

    private static boolean hasLongPatrolEffect(LivingEntity le) {
        if (le == null) {
            return false;
        }
        Collection effects = le.getActiveEffects();
        if (effects == null || effects.isEmpty()) {
            return false;
        }
        for (MobEffectInstance inst : effects) {
            if (!((MobEffect)inst.getEffect().value()).equals(ValarianConquestModMobEffects.LONG_PATROL_POTION.get())) continue;
            return true;
        }
        return false;
    }
}

