/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.procedures;

import java.util.List;
import net.mcreator.valarian_conquest.init.ValarianConquestModEntities;
import net.mcreator.valarian_conquest.init.ValarianConquestModGameRules;
import net.mcreator.valarian_conquest.init.ValarianConquestModItems;
import net.mcreator.valarian_conquest.init.ValarianConquestModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class SpawnPatrolsProcedureProcedure {
    private static long lastSpawnTick = 0L;
    private static int nextSpawnDelay = 0;

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        SpawnPatrolsProcedureProcedure.execute((LevelAccessor)event.getLevel());
    }

    public static void execute(LevelAccessor world) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (!serverWorld.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        if (!serverWorld.getGameRules().getBoolean(ValarianConquestModGameRules.ALLOW_PATROLS)) {
            return;
        }
        long gameTime = serverWorld.getGameTime();
        if (gameTime < lastSpawnTick + (long)nextSpawnDelay) {
            return;
        }
        if (serverWorld.getRandom().nextInt(24000) != 0) {
            return;
        }
        lastSpawnTick = gameTime;
        nextSpawnDelay = 24000;
        List players = serverWorld.players();
        if (players.isEmpty()) {
            return;
        }
        RandomSource random = serverWorld.getRandom();
        ServerPlayer player = (ServerPlayer)players.get(random.nextInt(players.size()));
        BlockPos playerPos = player.blockPosition();
        if (serverWorld.isVillage(playerPos)) {
            return;
        }
        double baseX = player.getX();
        double baseZ = player.getZ();
        BlockPos spawnPos = null;
        for (int attempts = 0; attempts < 25; ++attempts) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double distance = 64 + random.nextInt(65);
            double spawnX = baseX + Math.cos(angle) * distance;
            double spawnZ = baseZ + Math.sin(angle) * distance;
            BlockPos candidate = new BlockPos((int)spawnX, 0, (int)spawnZ);
            double spawnY = serverWorld.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, candidate).getY();
            BlockPos surface = new BlockPos(candidate.getX(), (int)spawnY - 1, candidate.getZ());
            boolean nearWater = false;
            for (int dx = -4; dx <= 4 && !nearWater; ++dx) {
                for (int dz = -4; dz <= 4 && !nearWater; ++dz) {
                    BlockPos check = surface.offset(dx, 0, dz);
                    if (!serverWorld.getFluidState(check).isSource()) continue;
                    nearWater = true;
                }
            }
            if (nearWater) continue;
            spawnPos = new BlockPos(candidate.getX(), (int)spawnY, candidate.getZ());
            break;
        }
        if (spawnPos == null) {
            return;
        }
        String faction = SpawnPatrolsProcedureProcedure.pickRandomFaction(random);
        int soldierCount = 2;
        for (int i = 0; i < soldierCount; ++i) {
            Entity spawned;
            double gz;
            double gy;
            double offsetX = -10.0 + random.nextDouble() * 20.0;
            double offsetZ = -10.0 + random.nextDouble() * 20.0;
            double gx = (double)spawnPos.getX() + offsetX;
            BlockPos below = new BlockPos((int)gx, (int)(gy = (double)serverWorld.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((int)gx, 0, (int)(gz = (double)spawnPos.getZ() + offsetZ))).getY()) - 1, (int)gz);
            if (serverWorld.getBlockState(below).getFluidState().isSource() || !((spawned = ((EntityType)ValarianConquestModEntities.SOLDIER.get()).spawn(serverWorld, BlockPos.containing((double)gx, (double)gy, (double)gz), MobSpawnType.MOB_SUMMONED)) instanceof PathfinderMob)) continue;
            PathfinderMob mob = (PathfinderMob)spawned;
            SpawnPatrolsProcedureProcedure.equipFactionGear((LivingEntity)mob, faction);
            SpawnPatrolsProcedureProcedure.assignTeam(serverWorld, (Entity)mob, faction);
            mob.addEffect(new MobEffectInstance(ValarianConquestModMobEffects.LONG_PATROL_POTION, 720000, 0, false, false));
            Horse horse = new Horse(EntityType.HORSE, (Level)serverWorld);
            horse.moveTo(gx + 0.5, gy, gz + 0.5, random.nextFloat() * 360.0f, 0.0f);
            horse.setTamed(true);
            horse.equipSaddle(new ItemStack((ItemLike)Items.SADDLE), SoundSource.NEUTRAL);
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("Variant", random.nextInt(35));
            horse.readAdditionalSaveData(nbt);
            serverWorld.addFreshEntity((Entity)horse);
            mob.startRiding((Entity)horse);
        }
    }

    private static String pickRandomFaction(RandomSource random) {
        double roll = random.nextDouble();
        if (roll < 0.142) {
            return "Valarians";
        }
        if (roll < 0.284) {
            return "Templars";
        }
        if (roll < 0.426) {
            return "Hospitallers";
        }
        if (roll < 0.568) {
            return "Barathians";
        }
        if (roll < 0.71) {
            return "Orleanians";
        }
        if (roll < 0.852) {
            return "Visgothians";
        }
        return "Bandits";
    }

    private static void equipFactionGear(LivingEntity entity, String faction) {
        switch (faction) {
            case "Valarians": {
                SpawnPatrolsProcedureProcedure.equipValarianGear(entity);
                break;
            }
            case "Templars": {
                SpawnPatrolsProcedureProcedure.equipTemplarGear(entity);
                break;
            }
            case "Hospitallers": {
                SpawnPatrolsProcedureProcedure.equipHospitallerGear(entity);
                break;
            }
            case "Barathians": {
                SpawnPatrolsProcedureProcedure.equipBarathianGear(entity);
                break;
            }
            case "Orleanians": {
                SpawnPatrolsProcedureProcedure.equipOrleanianGear(entity);
                break;
            }
            case "Visgothians": {
                SpawnPatrolsProcedureProcedure.equipVisgothianGear(entity);
                break;
            }
            case "Bandits": {
                SpawnPatrolsProcedureProcedure.equipBanditGear(entity);
            }
        }
    }

    private static void equipValarianGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.VALARIAN_SWORD.get(), (Item)ValarianConquestModItems.VALARIAN_SHIELD.get(), (Item)ValarianConquestModItems.NASAL_HELM_HELMET.get(), (Item)ValarianConquestModItems.VALARIAN_ARMOR_1_CHESTPLATE.get(), (Item)ValarianConquestModItems.VALARIAN_ARMOR_2_LEGGINGS.get(), (Item)ValarianConquestModItems.VALARIAN_ARMOR_1_BOOTS.get());
    }

    private static void equipTemplarGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.TEMPLAR_SWORD.get(), (Item)ValarianConquestModItems.TEMPLAR_SHIELD.get(), (Item)ValarianConquestModItems.NASAL_HELM_HELMET.get(), (Item)ValarianConquestModItems.TEMPLAR_ARMOR_2_CHESTPLATE.get(), (Item)ValarianConquestModItems.TEMPLAR_ARMOR_2_LEGGINGS.get(), (Item)ValarianConquestModItems.TEMPLAR_ARMOR_1_BOOTS.get());
    }

    private static void equipHospitallerGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.HOSPITALLER_SWORD.get(), (Item)ValarianConquestModItems.HOSPITALLER_SHIELD.get(), (Item)ValarianConquestModItems.NASAL_HELM_HELMET.get(), (Item)ValarianConquestModItems.HOSPITALLER_ARMOR_2_CHESTPLATE.get(), (Item)ValarianConquestModItems.HOSPITALLER_ARMOR_2_LEGGINGS.get(), (Item)ValarianConquestModItems.HOSPITALLER_ARMOR_1_BOOTS.get());
    }

    private static void equipBarathianGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.BARATHIAN_SWORD.get(), (Item)ValarianConquestModItems.BARATHIAN_SHIELD.get(), (Item)ValarianConquestModItems.NASAL_HELM_HELMET.get(), (Item)ValarianConquestModItems.BARATHIANS_ARMOR_2_CHESTPLATE.get(), (Item)ValarianConquestModItems.BARATHIANS_ARMOR_2_LEGGINGS.get(), (Item)ValarianConquestModItems.BARATHIANS_ARMOR_1_BOOTS.get());
    }

    private static void equipOrleanianGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.ORLEANIAN_SWORD.get(), (Item)ValarianConquestModItems.ORLEANIAN_SHIELD.get(), (Item)ValarianConquestModItems.NASAL_HELM_HELMET.get(), (Item)ValarianConquestModItems.ORLEANIAN_ARMOR_2_CHESTPLATE.get(), (Item)ValarianConquestModItems.ORLEANIAN_ARMOR_2_LEGGINGS.get(), (Item)ValarianConquestModItems.ORLEANIAN_ARMOR_1_BOOTS.get());
    }

    private static void equipVisgothianGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.VISGOTHIAN_SWORD.get(), (Item)ValarianConquestModItems.VISGOTHIAN_SHIELD.get(), (Item)ValarianConquestModItems.NASAL_HELM_HELMET.get(), (Item)ValarianConquestModItems.VISGOTHIAN_ARMOR_2_CHESTPLATE.get(), (Item)ValarianConquestModItems.VISGOTHIAN_ARMOR_3_LEGGINGS.get(), (Item)ValarianConquestModItems.VISGOTHIAN_ARMOR_1_BOOTS.get());
    }

    private static void equipBanditGear(LivingEntity entity) {
        SpawnPatrolsProcedureProcedure.setEquipment(entity, (Item)ValarianConquestModItems.COMMON_SWORD.get(), (Item)ValarianConquestModItems.WOODEN_SHIELD.get(), (Item)ValarianConquestModItems.BANDIT_MASK_HELMET.get(), (Item)ValarianConquestModItems.LEATHER_ARMOR_CHESTPLATE.get(), (Item)ValarianConquestModItems.LEATHER_ARMOR_LEGGINGS.get(), (Item)ValarianConquestModItems.LEATHER_ARMOR_BOOTS.get());
    }

    private static void setEquipment(LivingEntity entity, Item mainhand, Item offhand, Item helmet, Item chest, Item legs, Item boots) {
        entity.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)mainhand));
        entity.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)offhand));
        entity.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)helmet));
        entity.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)chest));
        entity.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)legs));
        entity.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)boots));
    }

    private static void assignTeam(ServerLevel world, Entity entity, String faction) {
        PlayerTeam team = world.getScoreboard().getPlayerTeam(faction);
        if (team != null) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                world.getScoreboard().addPlayerToTeam(player.getGameProfile().getName(), team);
            } else {
                world.getScoreboard().addPlayerToTeam(entity.getStringUUID(), team);
            }
        }
        entity.getPersistentData().putString("TeamName", faction);
    }
}

