/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public record AddTemplatePoolElementsModifier(int priority, HolderSet<StructureTemplatePool> templatePools, List<Pair<StructurePoolElement, Integer>> elements) implements Modifier
{
    public static final MapCodec<AddTemplatePoolElementsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PRIORITY_DEFAULT.forGetter(AddTemplatePoolElementsModifier::priority), (App)LithostitchedCodecs.registrySet(Registries.TEMPLATE_POOL, "template_pools").forGetter(AddTemplatePoolElementsModifier::templatePools), (App)Codec.mapPair((MapCodec)StructurePoolElement.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(AddTemplatePoolElementsModifier::elements)).apply((Applicative)instance, AddTemplatePoolElementsModifier::new));

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }

    @Override
    public void applyModifier() {
        this.templatePools.stream().map(Holder::value).forEach(this::applyModifier);
    }

    private void applyModifier(StructureTemplatePool templatePool) {
        StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)templatePool;
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
        rawTemplates.addAll(this.elements());
        poolAccessor.setRawTemplates(rawTemplates);
        ObjectArrayList vanillaTemplates = new ObjectArrayList(poolAccessor.getVanillaTemplates());
        for (Pair<StructurePoolElement, Integer> pair : this.elements()) {
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                vanillaTemplates.add((Object)((StructurePoolElement)pair.getFirst()));
            }
        }
        poolAccessor.setVanillaTemplates((ObjectArrayList<StructurePoolElement>)vanillaTemplates);
    }
}

