/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.processor.condition.ProcessorCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public record Position(PosRuleTest predicate, PosAnchor anchor) implements ProcessorCondition
{
    public static final MapCodec<Position> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PosRuleTest.CODEC.fieldOf("predicate").forGetter(Position::predicate), (App)PosAnchor.CODEC.fieldOf("anchor").orElse((Object)PosAnchor.STRUCTURE_START).forGetter(Position::anchor)).apply((Applicative)instance, Position::new));

    @Override
    public boolean test(WorldGenLevel level, ProcessorCondition.Data data, StructurePlaceSettings settings, RandomSource random) {
        return this.predicate.test(data.relative().pos(), data.absolute().pos(), this.anchor.get(data), random);
    }

    @Override
    public MapCodec<? extends ProcessorCondition> codec() {
        return CODEC;
    }

    public static enum PosAnchor implements StringRepresentable
    {
        STRUCTURE_START("structure_start"),
        PIECE("piece");

        public static final Codec<PosAnchor> CODEC;
        private final String name;

        private PosAnchor(String name) {
            this.name = name;
        }

        public BlockPos get(ProcessorCondition.Data data) {
            return this == STRUCTURE_START ? data.pivot() : data.absolute().pos().subtract((Vec3i)data.relative().pos());
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PosAnchor::values);
        }
    }
}

