/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor.condition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.processor.condition.AllOf;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public interface ProcessorCondition {
    public static final Codec<ProcessorCondition> BASE_CODEC = Codec.lazyInitialized(() -> {
        Optional registry = BuiltInRegistries.REGISTRY.getOptional(LithostitchedRegistryKeys.PROCESSOR_CONDITION_TYPE.location());
        if (registry.isEmpty()) {
            throw new NullPointerException("Processor condition registry does not exist yet!");
        }
        return ((Registry)registry.get()).byNameCodec();
    }).dispatch(ProcessorCondition::codec, Function.identity());
    public static final Codec<ProcessorCondition> CODEC = Codec.withAlternative(BASE_CODEC, (Codec)BASE_CODEC.listOf(), AllOf::new);

    public boolean test(WorldGenLevel var1, Data var2, StructurePlaceSettings var3, RandomSource var4);

    public MapCodec<? extends ProcessorCondition> codec();

    public record Data(BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute) {
    }
}

