/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.api.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.magistuarmory.item.armor.DyeableMedievalArmorItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ArmorModelProvider
implements DataProvider {
    private final PackOutput output;
    private final String modid;
    private final List<DyeableMedievalArmorItem> armors;

    public ArmorModelProvider(PackOutput output, String modid, List<DyeableMedievalArmorItem> armors) {
        this.output = output;
        this.modid = modid;
        this.armors = armors;
    }

    @NotNull
    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (DyeableMedievalArmorItem armor : this.armors) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)armor);
            Path path = this.output.getOutputFolder().resolve("assets").resolve(id.getNamespace()).resolve("equipment").resolve(id.getPath() + ".json");
            JsonObject root = this.createEquipmentModelJson(id.getNamespace(), id.getPath(), armor.getDefaultColor());
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)root, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private JsonObject createEquipmentModelJson(String namespace, String name, int defaultColor) {
        JsonObject root = new JsonObject();
        JsonObject layers = new JsonObject();
        layers.add("humanoid", (JsonElement)this.humanoidLayer(namespace, name, defaultColor));
        layers.add("humanoid_leggings", (JsonElement)this.leggingsLayer(namespace, name, defaultColor));
        root.add("layers", (JsonElement)layers);
        return root;
    }

    private JsonArray humanoidLayer(String ns, String name, int color) {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)this.texture(ns, "armor/" + name + "_outer"));
        arr.add((JsonElement)this.dyeableTexture(ns, "armor/" + name + "_outer_overlay", color));
        return arr;
    }

    private JsonArray leggingsLayer(String ns, String name, int color) {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)this.texture(ns, "armor/" + name + "_inner"));
        arr.add((JsonElement)this.dyeableTexture(ns, "armor/" + name + "_inner_overlay", color));
        return arr;
    }

    private JsonObject texture(String ns, String path) {
        JsonObject obj = new JsonObject();
        obj.addProperty("texture", ns + ":" + path);
        return obj;
    }

    private JsonObject dyeableTexture(String ns, String path, int color) {
        JsonObject obj = this.texture(ns, path);
        JsonObject dyeable = new JsonObject();
        dyeable.addProperty("color_when_undyed", (Number)color);
        obj.add("dyeable", (JsonElement)dyeable);
        return obj;
    }

    @NotNull
    public String getName() {
        return "Equipment Models";
    }
}

