/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render;

import com.magistuarmory.misc.HeraldryRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface PatternLayer {
    public VertexConsumer baseVertexConsumer(MultiBufferSource var1, boolean var2, boolean var3);

    public VertexConsumer basePatternVertexConsumer(MultiBufferSource var1, boolean var2);

    public VertexConsumer patternVertexConsumer(MultiBufferSource var1, ResourceLocation var2, boolean var3);

    default public void renderPatterns(PoseStack pose, MultiBufferSource buffer, int p, int overlay, List<Pair<Holder<BannerPattern>, DyeColor>> list, boolean hasfoil, ModelPart[] modelparts, DyeColor basecolor) {
        list = PatternLayer.filterFromUnregistered(list);
        for (ModelPart part : modelparts) {
            part.render(pose, this.baseVertexConsumer(buffer, basecolor != null, hasfoil), p, overlay, -1);
            if (basecolor != null) {
                part.render(pose, this.basePatternVertexConsumer(buffer, hasfoil), p, overlay, basecolor.getTextureDiffuseColor());
            }
            for (int i = 0; i < 17 && i < list.size(); ++i) {
                Pair<Holder<BannerPattern>, DyeColor> pair = list.get(i);
                int color = ((DyeColor)pair.getSecond()).getTextureDiffuseColor();
                part.render(pose, this.patternVertexConsumer(buffer, ((ResourceKey)((Holder)pair.getFirst()).unwrapKey().get()).location(), hasfoil), p, overlay, color);
            }
        }
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> filterFromUnregistered(List<Pair<Holder<BannerPattern>, DyeColor>> list) {
        return list.stream().filter(pair -> ((Holder)pair.getFirst()).unwrapKey().isPresent() && HeraldryRegistry.isRegistered(((ResourceKey)((Holder)pair.getFirst()).unwrapKey().get()).location().getPath())).collect(Collectors.toList());
    }
}

