/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.entity.layer;

import com.magistuarmory.client.render.entity.layer.ArmorPatternLayer;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.decoration.ArmorDecorationModel;
import com.magistuarmory.client.render.model.decoration.ArmorDecorationModelSet;
import com.magistuarmory.client.render.model.decoration.SurcoatModel;
import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.item.ArmorDecorationItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorDecorationLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M>
implements ArmorPatternLayer {
    private static final int[] CAT_COLORS = new int[]{0, 0xFFFFFF, 0x808080, 16753920, 9127187, 16770229, 0x6699CC, 9849600, 13148872, 16766720};
    private static final String ARMOR_DIR_PREFIX = "textures/models/armor/";
    private final ArmorDecorationModel<T> coatModel;
    private final String coatDirPrefix;
    private final ResourceLocation coatTexture;
    private final ResourceLocation basePatternTexture;
    private final ArmorDecorationModelSet<T> decorationModels;

    public ArmorDecorationLayer(ArmorDecorationModelSet<T> decorationModels, RenderLayerParent<T, M> parent, EntityRendererProvider.Context context, ResourceLocation location) {
        super(parent);
        this.decorationModels = decorationModels;
        this.coatModel = new SurcoatModel(context.bakeLayer(ModModels.createDecorationLocation(location)));
        this.coatDirPrefix = this.getDirPrefix(location);
        this.coatTexture = this.getTexture(location);
        this.basePatternTexture = ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)(this.coatDirPrefix + "base.png"));
    }

    public ResourceLocation getTexture(ResourceLocation location) {
        return this.getTexture(location, false);
    }

    public ResourceLocation getTexture(ResourceLocation location, boolean overlay) {
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(ARMOR_DIR_PREFIX + location.getPath() + (overlay ? "_overlay.png" : ".png")));
    }

    public String getDirPrefix(ResourceLocation location) {
        return ARMOR_DIR_PREFIX + location.getPath() + "/";
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int p, T entity, float f, float f2, float f3, float f4, float f5, float f6) {
        LocalDate today = LocalDate.now();
        if (today.getDayOfMonth() == 1 && today.getMonth() == Month.APRIL) {
            this.renderCat(pose, buffer, p, entity);
        }
        this.renderPiece(pose, buffer, entity, EquipmentSlot.CHEST, p);
        this.renderPiece(pose, buffer, entity, EquipmentSlot.LEGS, p);
        this.renderPiece(pose, buffer, entity, EquipmentSlot.FEET, p);
        this.renderPiece(pose, buffer, entity, EquipmentSlot.HEAD, p);
    }

    private void renderCat(PoseStack pose, MultiBufferSource buffer, int p, T entity) {
        ResourceLocation koshkodevochkaLocation = ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"cat_ears");
        ArmorDecorationModel<T> kittycatModel = this.decorationModels.get(koshkodevochkaLocation);
        ((HumanoidModel)this.getParentModel()).copyPropertiesTo(kittycatModel);
        int n = 0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String nickname = player.getDisplayName().getString();
            for (int i = 0; i < nickname.length(); ++i) {
                n += nickname.charAt(i);
            }
        } else {
            n = entity.getId();
        }
        boolean hasfoil = (n + LocalDateTime.now().getHour()) % 4 == 0;
        this.renderDecoration(pose, buffer, p, OverlayTexture.NO_OVERLAY, CAT_COLORS[n % CAT_COLORS.length], hasfoil, kittycatModel.parts(), this.getTexture(koshkodevochkaLocation));
        this.renderDecoration(pose, buffer, p, OverlayTexture.NO_OVERLAY, hasfoil, kittycatModel.parts(), this.getTexture(koshkodevochkaLocation, true));
    }

    private void renderPiece(PoseStack pose, MultiBufferSource buffer, T entity, EquipmentSlot slot, int p) {
        ArmorItem armoritem;
        ItemStack stack = entity.getItemBySlot(slot);
        Item item = stack.getItem();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).getEquipmentSlot() == slot) {
            if (stack.get((DataComponentType)ModDataComponents.ARMOR_DECORATION.get()) != null) {
                for (ArmorDecorationItem.DecorationInfo info : ArmorDecorationItem.createDecorations(ArmorDecorationItem.getDecorationTags(stack))) {
                    ResourceLocation location = info.location();
                    ArmorDecorationModel<T> model = this.getArmorDecorationModel(location);
                    if (model == null) continue;
                    ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
                    if (info.dyeable()) {
                        this.renderDecoration(pose, buffer, p, OverlayTexture.NO_OVERLAY, info.color(), stack.hasFoil(), model.parts(), this.getTexture(location));
                        this.renderDecoration(pose, buffer, p, OverlayTexture.NO_OVERLAY, stack.hasFoil(), model.parts(), this.getTexture(location, true));
                        continue;
                    }
                    this.renderDecoration(pose, buffer, p, OverlayTexture.NO_OVERLAY, stack.hasFoil(), model.parts(), this.getTexture(location));
                }
            }
            BannerPatternLayers patterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            if (armoritem.getEquipmentSlot() == EquipmentSlot.CHEST && patterns != null) {
                DyeColor basecolor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
                ((HumanoidModel)this.getParentModel()).copyPropertiesTo(this.coatModel);
                this.renderDecoration(pose, buffer, p, OverlayTexture.NO_OVERLAY, stack.hasFoil(), this.coatModel.parts(), this.coatTexture);
                ArrayList list = patterns == null ? new ArrayList() : patterns.layers().stream().map(l -> Pair.of((Object)l.pattern(), (Object)l.color())).collect(Collectors.toList());
                this.renderPatterns(pose, buffer, p, OverlayTexture.NO_OVERLAY, list, stack.hasFoil(), this.coatModel.parts(), basecolor);
            }
        }
    }

    public ArmorDecorationModel<T> getArmorDecorationModel(ResourceLocation location) {
        return this.decorationModels.get(location);
    }

    public void renderDecoration(PoseStack pose, MultiBufferSource buffer, int p, int overlay, boolean hasfoil, ModelPart[] modelparts, ResourceLocation texture) {
        this.renderDecoration(pose, buffer, p, overlay, -1, hasfoil, modelparts, texture);
    }

    public void renderDecoration(PoseStack pose, MultiBufferSource buffer, int p, int overlay, int color, boolean hasfoil, ModelPart[] modelparts, ResourceLocation texture) {
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)texture), (boolean)hasfoil);
        for (ModelPart part : modelparts) {
            part.render(pose, vertexconsumer, p, overlay, color);
        }
    }

    @Override
    public ResourceLocation getBaseTexture(boolean withPattern) {
        return this.coatTexture;
    }

    @Override
    public ResourceLocation getBasePatternTexture() {
        return this.basePatternTexture;
    }

    @Override
    public ResourceLocation getPatternTexture(ResourceLocation patternlocation) {
        return ResourceLocation.fromNamespaceAndPath((String)this.coatTexture.getNamespace(), (String)(this.coatDirPrefix + patternlocation.getPath() + ".png"));
    }
}

