/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.tileentity;

import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.item.MedievalShieldModel;
import com.magistuarmory.client.render.tileentity.ShieldPatternLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeraldryItemStackRenderer
extends BlockEntityWithoutLevelRenderer
implements ShieldPatternLayer {
    private Model model;
    private final ResourceLocation location;
    private final MaterialContainer materialContainer;

    public HeraldryItemStackRenderer(String id, ResourceLocation location) {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.location = location;
        this.materialContainer = new MaterialContainer(id, location, "entity/" + location.getPath() + "/");
    }

    public void loadModel(EntityRendererProvider.Context context) {
        this.model = new MedievalShieldModel(context.bakeLayer(ModModels.createLocation(this.location)));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack pose, MultiBufferSource buffer, int p, int overlay) {
        Model model = this.model;
        if (model instanceof MedievalShieldModel) {
            MedievalShieldModel shieldmodel = (MedievalShieldModel)model;
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            DyeColor baseColor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
            VertexConsumer vertexconsumer = this.getBaseMaterial(baseColor != null).sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getBaseMaterial(baseColor != null).atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
            shieldmodel.handle().render(pose, vertexconsumer, p, overlay, 0xFFFFFF);
            BannerPatternLayers patterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            ArrayList list = patterns == null ? new ArrayList() : patterns.layers().stream().map(l -> Pair.of((Object)l.pattern(), (Object)l.color())).collect(Collectors.toList());
            this.renderPatterns(pose, buffer, p, overlay, list, stack.hasFoil(), shieldmodel.plate(), baseColor);
            pose.popPose();
        }
    }

    @Override
    public Material getBaseMaterial(boolean withPattern) {
        return withPattern ? this.materialContainer.getBaseWithPatternMaterial() : this.materialContainer.getBaseWithoutPatternMaterial();
    }

    @Override
    public Material getBasePatternMaterial() {
        return this.materialContainer.getBasePatternMaterial();
    }

    @Override
    public Material getPatternMaterial(ResourceLocation patternLocation) {
        return this.materialContainer.getPatternMaterial(patternLocation);
    }

    private static final class MaterialContainer {
        private final String id;
        private final ResourceLocation location;
        private final String patternsDirectory;
        private Material baseWithPatternMaterial = null;
        private Material baseWithoutPatternMaterial = null;
        private Material basePatternMaterial = null;

        private MaterialContainer(String id, ResourceLocation location, String patternsDirectory) {
            this.id = id;
            this.location = location;
            this.patternsDirectory = patternsDirectory;
        }

        public synchronized Material getBaseWithPatternMaterial() {
            if (this.baseWithPatternMaterial == null) {
                this.baseWithPatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)("entity/" + this.id + "_pattern")));
            }
            return this.baseWithPatternMaterial;
        }

        public synchronized Material getBaseWithoutPatternMaterial() {
            if (this.baseWithoutPatternMaterial == null) {
                this.baseWithoutPatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)("entity/" + this.id + "_nopattern")));
            }
            return this.baseWithoutPatternMaterial;
        }

        public synchronized Material getBasePatternMaterial() {
            if (this.basePatternMaterial == null) {
                this.basePatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.patternsDirectory + "base")));
            }
            return this.basePatternMaterial;
        }

        public Material getPatternMaterial(ResourceLocation patternLocation) {
            return new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.patternsDirectory + patternLocation.getPath())));
        }
    }
}

