/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.tileentity;

import com.magistuarmory.block.PaviseBlockEntity;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.block.PaviseBlockModel;
import com.magistuarmory.client.render.model.item.MedievalShieldModel;
import com.magistuarmory.client.render.tileentity.ShieldPatternLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaviseBlockRenderer
implements BlockEntityRenderer<PaviseBlockEntity>,
ShieldPatternLayer {
    private final PaviseBlockModel model;
    private final ResourceLocation location;
    private final String patternsDirectory;
    private final Material baseWithPatternMaterial;
    private final Material baseWithoutPatternMaterial;
    private final Material basePatternMaterial;

    public PaviseBlockRenderer(BlockEntityRendererProvider.Context context, String id, ResourceLocation location) {
        this.model = new PaviseBlockModel(context.bakeLayer(ModModels.PAVISE_BLOCK_LOCATION));
        this.location = location;
        this.patternsDirectory = "entity/" + location.getPath() + "/";
        this.baseWithPatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("entity/" + id + "_pattern")));
        this.baseWithoutPatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("entity/" + id + "_nopattern")));
        this.basePatternMaterial = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.patternsDirectory + "base")));
    }

    public int getViewDistance() {
        return 128;
    }

    public void render(PaviseBlockEntity pavise, float f, PoseStack pose, MultiBufferSource buffer, int p, int overlay) {
        pose.pushPose();
        BlockState blockstate = pavise.getBlockState();
        pose.translate(0.5f, 0.5f, 0.5f);
        float yrot = (float)(-((Integer)blockstate.getValue((Property)BannerBlock.ROTATION)).intValue() * 360) / 16.0f;
        pose.mulPose(Axis.YP.rotationDegrees(yrot));
        this.renderPatterns(pavise, pose, buffer, p, OverlayTexture.NO_OVERLAY);
        pose.popPose();
    }

    public void renderPatterns(PaviseBlockEntity pavise, PoseStack pose, MultiBufferSource buffer, int p, int overlay) {
        PaviseBlockModel paviseBlockModel = this.model;
        if (paviseBlockModel instanceof MedievalShieldModel) {
            PaviseBlockModel shieldmodel = paviseBlockModel;
            pose.pushPose();
            pose.scale(1.0f, -1.0f, -1.0f);
            DyeColor basecolor = pavise.getBaseColor();
            VertexConsumer vertexconsumer = this.getBaseMaterial(basecolor != null).sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getBaseMaterial(basecolor != null).atlasLocation()), (boolean)true, (boolean)pavise.hasFoil()));
            shieldmodel.handle().render(pose, vertexconsumer, p, overlay, 0xFFFFFF);
            BannerPatternLayers patterns = pavise.getPatterns();
            ArrayList list = patterns == null ? new ArrayList() : patterns.layers().stream().map(l -> Pair.of((Object)l.pattern(), (Object)l.color())).collect(Collectors.toList());
            this.renderPatterns(pose, buffer, p, overlay, list, pavise.hasFoil(), shieldmodel.plate(), basecolor);
            pose.popPose();
        }
    }

    @Override
    public Material getBaseMaterial(boolean withPattern) {
        return withPattern ? this.baseWithPatternMaterial : this.baseWithoutPatternMaterial;
    }

    @Override
    public Material getBasePatternMaterial() {
        return this.basePatternMaterial;
    }

    @Override
    public Material getPatternMaterial(ResourceLocation patternlocation) {
        return new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.patternsDirectory + patternlocation.getPath())));
    }
}

