/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.Lists;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.item.ArmorDecoration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArmorDecorationItem
extends Item
implements ArmorDecoration {
    ResourceLocation location;
    ArmorItem.Type armorType;

    public ArmorDecorationItem(ResourceLocation location, Item.Properties properties, ArmorItem.Type armorType) {
        super(properties.stacksTo(1));
        this.location = location;
        this.armorType = armorType;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    @Override
    public ArmorItem.Type getType() {
        return this.armorType;
    }

    public static List<DecorationInfo> createDecorations(@Nullable ListTag listtag) {
        ArrayList list = Lists.newArrayList();
        if (listtag != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag tag = listtag.getCompound(i);
                String name = tag.getString("name");
                boolean dyeable = tag.getBoolean("dyeable");
                int j = tag.getInt("color");
                list.add(new DecorationInfo(name, dyeable, j));
            }
        }
        return list;
    }

    @Override
    public CompoundTag getCompoundTag(ItemStack stack) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.putString("name", this.location.toString());
        compoundnbt.putBoolean("dyeable", false);
        compoundnbt.putInt("color", 1);
        return compoundnbt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableForDecoration(ItemStack stack) {
        if (ArmorDecorationItem.getDecorationTags(stack).size() >= 8) return false;
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem)) return false;
        ArmorItem armor = (ArmorItem)item;
        if (this.getType() != armor.getType()) return false;
        return true;
    }

    public static ListTag getDecorationTags(ItemStack stack) {
        CustomData data = (CustomData)stack.get((DataComponentType)ModDataComponents.ARMOR_DECORATION.get());
        return data == null ? new ListTag() : data.copyTag().getList("Items", 10);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)("magistuarmory.armor_decoration." + this.getType().getName() + ".description")).withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withItalic(Boolean.valueOf(true))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelLayerLocation createModelLocation() {
        return ModModels.createDecorationLocation(this.location);
    }

    public record DecorationInfo(String name, boolean dyeable, int color) {
        public ResourceLocation location() {
            ResourceLocation loc = ResourceLocation.parse((String)this.name);
            return ResourceLocation.fromNamespaceAndPath((String)(!loc.getNamespace().equals("minecraft") ? loc.getNamespace() : "magistuarmory"), (String)loc.getPath());
        }
    }
}

