/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.item.ArmorDecorationItem;
import com.magistuarmory.item.DyeableItemLike;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class DyeableArmorDecorationItem
extends ArmorDecorationItem
implements DyeableItemLike {
    int defaultcolor;

    public DyeableArmorDecorationItem(ResourceLocation location, Item.Properties properties, ArmorItem.Type armorType) {
        this(location, properties, armorType, -1);
        this.armorType = armorType;
    }

    public DyeableArmorDecorationItem(ResourceLocation location, Item.Properties properties, ArmorItem.Type armorType, int defaultcolor) {
        super(location, properties, armorType);
        this.defaultcolor = FastColor.ARGB32.opaque((int)defaultcolor);
    }

    public void setColor(ItemStack stack, int color) {
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
    }

    @Override
    public int getColor(ItemStack stack) {
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        return FastColor.ARGB32.opaque((int)(color != null ? color.rgb() : this.defaultcolor));
    }

    @Override
    public CompoundTag getCompoundTag(ItemStack stack) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.putString("name", this.location.toString());
        compoundnbt.putBoolean("dyeable", true);
        compoundnbt.putInt("color", this.getColor(stack));
        return compoundnbt;
    }
}

