/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class MedievalBagItem
extends Item {
    public MedievalBagItem() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder result = super.use(level, player, hand);
        if (level.isClientSide() || result.getResult().consumesAction()) {
            return result;
        }
        ItemStack bagstack = player.getItemInHand(hand);
        player.getInventory().setItem(player.getInventory().findSlotMatchingItem(bagstack), ItemStack.EMPTY);
        MedievalBagItem.getContents(bagstack).nonEmptyStream().forEach(s -> {
            if (!player.addItem(s)) {
                level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), s));
            }
        });
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)bagstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"medieval_bag.rightclick").withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withItalic(Boolean.valueOf(true))));
    }

    public static void setContents(ItemStack bagstack, List<ItemStack> stacks) {
        bagstack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(stacks));
    }

    public static ItemContainerContents getContents(ItemStack bagstack) {
        return (ItemContainerContents)bagstack.get(DataComponents.CONTAINER);
    }
}

