/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.item.IHasModelProperty;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MedievalCrossbowItem
extends CrossbowItem
implements IHasModelProperty {
    static CrossbowItem.ChargingSounds DEFAULT_SOUNDS = new CrossbowItem.ChargingSounds(Optional.of(SoundEvents.CROSSBOW_LOADING_START), Optional.of(SoundEvents.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEvents.CROSSBOW_LOADING_END));
    private final int pullTime;
    private final float projectileSpeed;
    protected boolean startSoundPlayed = false;
    protected boolean midLoadSoundPlayed = false;

    public MedievalCrossbowItem(Item.Properties properties, float projectileSpeed, int pullTime) {
        super(properties.stacksTo(1));
        this.projectileSpeed = projectileSpeed;
        this.pullTime = pullTime;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)itemStack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            this.performShooting(level, (LivingEntity)player, interactionHand, itemStack, this.getProjectileSpeed(chargedProjectiles), 1.0f, null);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        if (!player.getProjectile(itemStack).isEmpty()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            player.startUsingItem(interactionHand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        int j = this.getUseDuration(itemStack, livingEntity) - i;
        float f = this.getPower(j, itemStack, livingEntity);
        if (f >= 1.0f && !MedievalCrossbowItem.isCharged((ItemStack)itemStack) && MedievalCrossbowItem.tryLoadProjectiles(livingEntity, itemStack)) {
            CrossbowItem.ChargingSounds chargingSounds = this.getChargingSounds(itemStack);
            chargingSounds.end().ifPresent(holder -> level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), (SoundEvent)holder.value(), livingEntity.getSoundSource(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity livingEntity, ItemStack itemStack) {
        List list = MedievalCrossbowItem.draw((ItemStack)itemStack, (ItemStack)livingEntity.getProjectile(itemStack), (LivingEntity)livingEntity);
        if (!list.isEmpty()) {
            itemStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
            return true;
        }
        return false;
    }

    CrossbowItem.ChargingSounds getChargingSounds(ItemStack itemStack) {
        return EnchantmentHelper.pickHighestLevel((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_SOUNDS);
    }

    private float getProjectileSpeed(ChargedProjectiles chargedProjectiles) {
        return chargedProjectiles.contains(Items.FIREWORK_ROCKET) ? this.projectileSpeed / 2.0f : this.projectileSpeed;
    }

    public int getPullTime(ItemStack itemStack, LivingEntity shooter) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)itemStack, (LivingEntity)shooter, (float)((float)this.pullTime / 20.0f));
        return Mth.floor((float)(f * 20.0f));
    }

    private float getPower(int p_40854_, ItemStack stack, LivingEntity shooter) {
        float f = (float)p_40854_ / (float)this.getPullTime(stack, shooter);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.getPullTime(stack, entity) + 3;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            return CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / (float)this.getPullTime(stack, entity);
        });
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (stack, level, entity, i) -> entity != null && CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (stack, level, entity, i) -> entity != null && CrossbowItem.isCharged((ItemStack)stack) && stack.has(DataComponents.CHARGED_PROJECTILES) && ((ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES)).contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f);
    }
}

