/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.EpicKnights;
import com.magistuarmory.component.ModDataComponents;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSources;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MedievalWeaponItem
extends SwordItem
implements IHasModelProperty {
    public static final ResourceLocation BASE_ENTITY_INTERACTION_RANGE_ID = ResourceLocation.fromNamespaceAndPath((String)"magistuarmory", (String)"base_entity_interaction_range_id");
    private final ItemAttributeModifiers defaultModifiers;
    private final ItemAttributeModifiers decreasedModifiers;
    public final WeaponType type;
    protected final float attackDamage;
    private boolean isSilver = false;
    private float silverAttackDamage = 0.0f;
    private boolean blockingPriority = false;

    public MedievalWeaponItem(Item.Properties properties, ModItemTier material, WeaponType type) {
        super((Tier)material, properties.stacksTo(1).durability(type.getDurability(material)).attributes(MedievalWeaponItem.createDefaultAttributeModifiersBuilder(material, type).build()));
        this.type = type;
        this.attackDamage = CombatHelper.getBaseAttackDamage(material, type);
        if (material.equals(ModItemTier.SILVER)) {
            this.isSilver = true;
            this.silverAttackDamage = CombatHelper.getSilverAttackDamage(material, type);
        }
        this.defaultModifiers = MedievalWeaponItem.createDefaultAttributeModifiersBuilder(material, type).build();
        this.decreasedModifiers = MedievalWeaponItem.createDecreasedAttributeModifiersBuilder(material, type).build();
    }

    public static ItemAttributeModifiers.Builder createDefaultAttributeModifiersBuilder(ModItemTier material, WeaponType type) {
        return MedievalWeaponItem.createAttributeModifiersBuilder(CombatHelper.getBaseAttackDamage(material, type), CombatHelper.getBaseAttackSpeed(material, type), type.getBonusAttackReach());
    }

    public static ItemAttributeModifiers.Builder createDecreasedAttributeModifiersBuilder(ModItemTier material, WeaponType type) {
        return MedievalWeaponItem.createAttributeModifiersBuilder(CombatHelper.getDecreasedAttackDamage(material, type), CombatHelper.getDecreasedAttackSpeed(material, type), type.getBonusAttackReach());
    }

    public static ItemAttributeModifiers.Builder createAttributeModifiersBuilder(float damage, float speed, float reach) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_ENTITY_INTERACTION_RANGE_ID, (double)reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder;
    }

    public boolean onAttackClickEntity(ItemStack stack, Player player, Entity entity) {
        return true;
    }

    public ItemAttributeModifiers getAttributeModifiers(ItemStack stack) {
        return this.hasTwoHandedPenalty(stack) ? this.decreasedModifiers : this.defaultModifiers;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean selected) {
        if (entity instanceof LivingEntity) {
            boolean penalty;
            LivingEntity livingentity = (LivingEntity)entity;
            boolean bl = penalty = this.type.getTwoHanded() > 0 && !livingentity.getOffhandItem().getItem().equals(Items.AIR);
            if (this.hasTwoHandedPenalty(stack) != penalty) {
                stack.set((DataComponentType)ModDataComponents.TWO_HANDED_PENALTY.get(), (Object)(penalty ? this.type.getTwoHanded() : 0));
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)this.getAttributeModifiers(stack));
            }
            if (this.canBlock()) {
                this.blockingPriority = !(livingentity.getMainHandItem().getItem() instanceof ShieldItem) && !(livingentity.getOffhandItem().getItem() instanceof ShieldItem);
            }
        }
        super.inventoryTick(stack, level, entity, i, selected);
    }

    public boolean onHurtEntity(DamageSource source, LivingEntity victim, float damage) {
        float attackscale;
        Entity entity;
        if (victim.level().isClientSide() || ModDamageSources.isAdditional(source) || !((entity = source.getEntity()) instanceof LivingEntity)) {
            return true;
        }
        LivingEntity attacker = (LivingEntity)entity;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            v0 = damage / this.getAttackDamage(livingentity.getMainHandItem());
        } else {
            v0 = attackscale = 1.0f;
        }
        if (this.type.isHalberd() && victim.isPassenger() && (float)victim.level().getRandom().nextInt(20) * attackscale >= 14.0f) {
            victim.stopRiding();
        }
        boolean flag = false;
        if (this.isSilver()) {
            flag = this.dealSilverDamage(source, attacker, victim, damage, attackscale);
        }
        if (!flag && this.type.getArmorPiercing() != 0 && victim.getArmorValue() > 0) {
            flag = this.dealArmorPiercingDamage(source, attacker, victim, damage);
        }
        if (this.type.isFlamebladed()) {
            LacerationEffect.apply(source, victim, damage * attackscale);
        }
        this.postHurtEnemy(attacker.getWeaponItem(), attacker, victim);
        return flag;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        if (this.isSilver) {
            tooltip.add((Component)Component.translatable((String)"silvertools.hurt", (Object[])new Object[]{Float.valueOf(this.silverAttackDamage)}).withStyle(ChatFormatting.GREEN));
        }
        if (this.type.isFlamebladed()) {
            tooltip.add((Component)Component.translatable((String)"flamebladed.hurt").withStyle(ChatFormatting.BLUE));
        }
        if (this.type.isHalberd()) {
            tooltip.add((Component)Component.translatable((String)"halberd.hurt").withStyle(ChatFormatting.BLUE));
        }
        if (this.type.getArmorPiercing() != 0) {
            tooltip.add((Component)Component.translatable((String)"armorpiercing", (Object[])new Object[]{this.type.getArmorPiercing()}).withStyle(ChatFormatting.BLUE));
        }
        if (this.isLong()) {
            tooltip.add((Component)Component.translatable((String)"bonusattackreach", (Object[])new Object[]{Float.valueOf(this.type.getBonusAttackReach())}).withStyle(ChatFormatting.BLUE));
        }
        if (this.type.getTwoHanded() == 1) {
            tooltip.add((Component)Component.translatable((String)"twohandedi").withStyle(ChatFormatting.BLUE));
        } else if (this.type.getTwoHanded() > 1) {
            tooltip.add((Component)Component.translatable((String)"twohandedii").withStyle(ChatFormatting.BLUE));
        }
        if (this.canBlock()) {
            tooltip.add((Component)Component.translatable((String)"maxdamageblock", (Object[])new Object[]{Float.valueOf(this.getMaxBlockDamage())}).withStyle(ChatFormatting.BLUE));
        }
        tooltip.add((Component)Component.translatable((String)"kgweight", (Object[])new Object[]{Float.valueOf(this.getWeight())}).withStyle(ChatFormatting.BLUE));
        if (this.hasTwoHandedPenalty(stack)) {
            tooltip.add((Component)Component.translatable((String)"twohandedpenalty_1").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.translatable((String)"twohandedpenalty_2").withStyle(ChatFormatting.RED));
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }

    public boolean hasTwoHandedPenalty(ItemStack stack) {
        Integer value = (Integer)stack.get((DataComponentType)ModDataComponents.TWO_HANDED_PENALTY.get());
        return value != null && value > 0;
    }

    public float getAttackDamage(ItemStack stack) {
        return (float)this.getAttributeModifiers(stack).modifiers().stream().filter(m -> m.modifier().id().equals((Object)BASE_ATTACK_DAMAGE_ID)).findFirst().orElseThrow().modifier().amount();
    }

    public float getAttackReach(float baseReach) {
        return baseReach + this.getBonusAttackReach();
    }

    public float getBonusAttackReach() {
        return EpicKnights.BC_or_EF_installed ? 0.0f : this.type.getBonusAttackReach();
    }

    public boolean isLong() {
        return (double)this.getBonusAttackReach() > 0.0;
    }

    @Deprecated(forRemoval=true)
    public float getSilverDamage(ItemStack stack, float damage) {
        return this.silverAttackDamage * damage / this.getAttackDamage(stack);
    }

    public float getMaxBlockDamage() {
        return this.type.getMaxBlockDamage();
    }

    public float getWeight() {
        return this.type.getWeight();
    }

    public boolean isSilver() {
        return this.isSilver;
    }

    public boolean canBlock(Player player) {
        return player.getAttackStrengthScale(0.0f) == 1.0f && this.canBlock();
    }

    public boolean canBlock() {
        return this.type.canBlock();
    }

    boolean haveBlocked(RandomSource rand, DamageSource source) {
        return source.isDirect() && (float)rand.nextInt(18) > this.getWeight();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.canBlock(player) && this.blockingPriority) {
            ItemStack stack = player.getItemInHand(hand);
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.canBlock() ? (int)(500.0f / this.getWeight()) : 0;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.canBlock() && this.blockingPriority ? UseAnim.BLOCK : super.getUseAnimation(stack);
    }

    public void onBlocked(ItemStack stack, float damage, LivingEntity victim, DamageSource source) {
        if (!this.canBlock() || ModDamageSources.isAdditional(source)) {
            return;
        }
        Entity attacker = source.getEntity();
        float f = CombatHelper.getArmorPiercingFactor(attacker);
        if (source.is(DamageTypes.PLAYER_EXPLOSION) || source.is(DamageTypes.EXPLOSION)) {
            victim.hurt(ModDamageSources.additional(), damage);
        } else if (!this.haveBlocked(victim.level().getRandom(), source)) {
            victim.hurt(ModDamageSources.additional(), damage);
        } else if (damage > this.getMaxBlockDamage()) {
            f *= 1.5f;
            float damage1 = damage - this.getMaxBlockDamage();
            victim.hurt(ModDamageSources.additional(), damage1);
        }
        stack.hurtAndBreak((int)(f * damage), victim, EquipmentSlot.MAINHAND);
    }

    public boolean dealSilverDamage(DamageSource source, LivingEntity attacker, LivingEntity victim, float damage, float attackscale) {
        if (victim.getType().is(EntityTypeTags.UNDEAD)) {
            victim.hurt(ModDamageSources.silverAttack((Entity)attacker), CombatHelper.getDamageAfterAbsorb(source, victim, this.silverAttackDamage) * attackscale + damage);
            return true;
        }
        return false;
    }

    public boolean dealArmorPiercingDamage(DamageSource source, LivingEntity attacker, LivingEntity victim, float damage) {
        float afterabsorb = CombatHelper.getDamageAfterAbsorb(source, victim, damage);
        afterabsorb = Math.max(afterabsorb - victim.getAbsorptionAmount(), 0.0f);
        float pierced = Math.max((float)this.type.getArmorPiercing() / 100.0f * (damage - afterabsorb), 0.0f);
        victim.hurt(ModDamageSources.armorPiercing((Entity)attacker), damage + pierced);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        if (this.canBlock()) {
            ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }
    }
}

