/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.armor;

import com.magistuarmory.item.DyeableItemLike;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.MedievalArmorItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;

public class DyeableMedievalArmorItem
extends MedievalArmorItem
implements DyeableItemLike {
    private final int defaultcolor;

    public DyeableMedievalArmorItem(ArmorType material, ArmorItem.Type type, Item.Properties properties, int defaultcolor) {
        super(material, type, properties);
        this.defaultcolor = defaultcolor;
    }

    public int getDefaultColor() {
        return this.defaultcolor;
    }

    @Override
    public int getColor(ItemStack stack) {
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        return FastColor.ARGB32.opaque((int)(color != null ? color.rgb() : this.getDefaultColor()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"magistuarmory.dyeable_armor.description").withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withItalic(Boolean.valueOf(true))));
    }
}

