/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.armor;

import com.magistuarmory.api.client.render.model.ModModelsProvider;
import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.ArmorDecorationItem;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.DyeableMedievalArmorItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DyeableWearableArmorDecorationItem
extends DyeableMedievalArmorItem
implements ArmorDecoration {
    public DyeableWearableArmorDecorationItem(ArmorType material, ArmorItem.Type type, Item.Properties properties, int defaultcolor) {
        super(material, type, properties, defaultcolor);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.getArmorType().getLocation();
    }

    @Override
    public CompoundTag getCompoundTag(ItemStack stack) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.putString("name", this.getResourceLocation().toString());
        compoundnbt.putBoolean("dyeable", true);
        compoundnbt.putInt("color", this.getColor(stack));
        return compoundnbt;
    }

    @Override
    @NotNull
    public ArmorItem.Type getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableForDecoration(ItemStack stack) {
        if (stack.getItem() == this) return false;
        if (ArmorDecorationItem.getDecorationTags(stack).size() >= 8) return false;
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem)) return false;
        ArmorItem armor = (ArmorItem)item;
        if (this.getType() != armor.getType()) return false;
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)("magistuarmory.armor_decoration." + this.getType().getName() + ".description")).withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withItalic(Boolean.valueOf(true))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelLayerLocation createModelLocation() {
        return ModModelsProvider.createDecorationLocation(this.getResourceLocation());
    }
}

