/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.crafting;

import com.magistuarmory.EpicKnights;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.armor.ISurcoat;
import com.magistuarmory.item.crafting.neoforge.HeraldryRecipeImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;

public class HeraldryRecipe
extends CustomRecipe {
    public static RecipeSerializer<HeraldryRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(HeraldryRecipe::new);

    public HeraldryRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        ItemStack stack = ItemStack.EMPTY;
        ItemStack stack2 = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack3 = container.getItem(i);
            if (stack3.isEmpty()) continue;
            if (stack3.getItem() instanceof BannerItem) {
                if (!stack2.isEmpty()) {
                    return false;
                }
                stack2 = stack3;
                continue;
            }
            if (!HeraldryRecipe.isApplicableForBanner(stack3.getItem())) {
                return false;
            }
            if (!stack.isEmpty()) {
                return false;
            }
            BannerPatternLayers patterns = (BannerPatternLayers)stack3.get(DataComponents.BANNER_PATTERNS);
            if (patterns != null && !patterns.layers().isEmpty()) {
                return false;
            }
            stack = stack3;
        }
        return !stack.isEmpty() && !stack2.isEmpty();
    }

    @NotNull
    public ItemStack assemble(CraftingInput container, @NotNull HolderLookup.Provider access) {
        ItemStack stack = ItemStack.EMPTY;
        ItemStack stack1 = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack2 = container.getItem(i);
            if (stack2.isEmpty()) continue;
            if (stack2.getItem() instanceof BannerItem) {
                stack = stack2;
                continue;
            }
            if (!HeraldryRecipe.isApplicableForBanner(stack2.getItem())) continue;
            stack1 = stack2.copy();
        }
        if (!stack1.isEmpty()) {
            BannerPatternLayers patterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            DyeColor color = ((BannerItem)stack.getItem()).getColor();
            if (HeraldryRecipe.wornWithSurcoat(stack1.getItem())) {
                stack1.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("magistuarmory.withsurcoat." + color.getName()), (Object[])new Object[]{stack1.getHoverName().getString()}));
            } else if (HeraldryRecipe.wornWithCaparison(stack1.getItem())) {
                stack1.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("magistuarmory.withcaparison." + color.getName()), (Object[])new Object[]{stack1.getHoverName().getString()}));
            }
            if (patterns != null) {
                stack1.set(DataComponents.BANNER_PATTERNS, (Object)patterns);
            }
            stack1.set(DataComponents.BASE_COLOR, (Object)color);
        }
        return stack1;
    }

    public boolean canCraftInDimensions(int p_44298_, int p_44299_) {
        return p_44298_ * p_44299_ >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return HeraldryRecipe.getSerializerInstance();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<HeraldryRecipe> getSerializerInstance() {
        return HeraldryRecipeImpl.getSerializerInstance();
    }

    static boolean isPaintableShield(Item item) {
        return item instanceof MedievalShieldItem && ((MedievalShieldItem)item).isPaintable();
    }

    static boolean wornWithCaparison(Item item) {
        AnimalArmorItem animalarmor;
        return item instanceof AnimalArmorItem && (animalarmor = (AnimalArmorItem)item).getBodyType().equals((Object)AnimalArmorItem.BodyType.EQUESTRIAN);
    }

    static boolean wornWithSurcoat(Item item) {
        return item instanceof ArmorItem && (EpicKnights.GENERAL_CONFIG.enableSurcoatRecipeForAllArmor || item instanceof ISurcoat) && ((ArmorItem)item).getType().getSlot().equals((Object)EquipmentSlot.CHEST);
    }

    static boolean isApplicableForBanner(Item item) {
        return HeraldryRecipe.isPaintableShield(item) || HeraldryRecipe.wornWithCaparison(item) || HeraldryRecipe.wornWithSurcoat(item);
    }
}

