/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import net.mehvahdjukaar.smarterfarmers.SFPlatformStuff;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Final
    @Shadow
    public static Map<Item, Integer> FOOD_POINTS;

    @Shadow
    public abstract VillagerData getVillagerData();

    protected VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"wantsToPickUp(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")})
    private boolean wantsToPickUp(boolean original, @Local(argsOnly=true) ItemStack stack) {
        Item i = stack.getItem();
        if (FOOD_POINTS.containsKey(i)) {
            return true;
        }
        if (SFPlatformStuff.isValidSeed(stack, (Villager)this)) {
            return this.smarterfarmers$isFarmer() && this.getInventory().canAddItem(stack);
        }
        return original;
    }

    @Unique
    private boolean smarterfarmers$isFarmer() {
        return this.getVillagerData().getProfession() == VillagerProfession.FARMER;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource pSource) {
        if (pSource == this.damageSources().sweetBerryBush() && this.smarterfarmers$isFarmer()) {
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }

    @Inject(method={"handleEntityEvent(B)V"}, at={@At(value="HEAD")})
    public void smarterFarmers$addEatingParticles(byte pId, CallbackInfo ci) {
        if (pId == 45 && this.level().isClientSide) {
            SmarterFarmers.spawnEatingParticles(this);
        }
    }
}

