/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.sensor;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CopperGolemSpecificSensor
extends Sensor<CopperGolemEntity> {
    private static final Predicate<Player> NOTICEABLE_PLAYER_FILTER = player -> {
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Item itemInHand = itemStack.getItem();
        return itemInHand instanceof AxeItem && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(player);
    };
    private static final UniformInt AVOID_MEMORY_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)10);

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.AVOID_TARGET);
    }

    protected void doTick(ServerLevel world, CopperGolemEntity copperGolem) {
        Brain<CopperGolemEntity> brain = copperGolem.getBrain();
        if (brain.checkMemory(MemoryModuleType.AVOID_TARGET, MemoryStatus.VALUE_PRESENT)) {
            return;
        }
        List<ServerPlayer> players = world.players().stream().filter(NOTICEABLE_PLAYER_FILTER).filter(player -> copperGolem.closerThan((Entity)player, 16.0)).sorted(Comparator.comparingDouble(arg_0 -> ((CopperGolemEntity)copperGolem).distanceToSqr(arg_0))).toList();
        if (players.isEmpty() || !copperGolem.isWaxed()) {
            return;
        }
        brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get());
        brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)((LivingEntity)players.get(0)), (long)AVOID_MEMORY_DURATION.sample(copperGolem.getRandom()));
    }
}

