/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class MoyaiHeadLayer<T extends LivingEntity, M extends HierarchicalModel<T>>
extends RenderLayer<T, M> {
    private final ModelPart head;
    private final ItemInHandRenderer itemRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();

    public MoyaiHeadLayer(RenderLayerParent<T, M> parent) {
        super(parent);
        this.head = ((HierarchicalModel)this.getParentModel()).root().getChild("head");
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack = pLivingEntity.getItemBySlot(EquipmentSlot.HEAD);
        if (!itemstack.isEmpty()) {
            pMatrixStack.pushPose();
            this.head.translateAndRotate(pMatrixStack);
            MoyaiHeadLayer.translateToHead(pMatrixStack);
            this.itemRenderer.renderItem(pLivingEntity, itemstack, ItemDisplayContext.HEAD, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
        }
    }

    private static void translateToHead(PoseStack stack) {
        stack.translate(0.0, -0.25, 0.0);
        stack.mulPose(RotHlpr.Y180);
        stack.scale(0.625f, -0.625f, -0.625f);
        stack.translate(0.0, 0.296875, -0.125);
    }
}

