/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai.neoforge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.moyai.MoyaiHeadLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class MoyaiClientForge {
    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        MoyaiClientForge.addLayer((LivingEntityRenderer)event.getRenderer(EntityType.IRON_GOLEM));
    }

    private static <T extends LivingEntity, M extends HierarchicalModel<T>, R extends LivingEntityRenderer<T, M>> void addLayer(@Nullable R renderer) {
        if (renderer != null) {
            renderer.addLayer(new MoyaiHeadLayer(renderer));
        }
    }

    @EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class Rumbler {
        private static final int SHAKE_DURATION = 40;
        private static final int MAX_DIST = 16;
        private static final Map<BlockPos, Float> CACHED_POS = new HashMap<BlockPos, Float>();
        private static float animationCounter = 0.0f;

        public static void setShaking(BlockPos pos, int note) {
            float n = 1.0f - (float)note / 24.0f;
            LocalPlayer p = Minecraft.getInstance().player;
            if (p != null) {
                CACHED_POS.put(pos, Float.valueOf(40.0f * (0.75f * (n - 0.5f) + 1.0f)));
            }
        }

        private static double getIntensity(BlockPos pos, Player player) {
            double dist = player.position().distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            return Math.max(0.0, 256.0 - dist) / 256.0;
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            animationCounter += 1.0f;
        }

        @SubscribeEvent
        public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
            LocalPlayer p = Minecraft.getInstance().player;
            if (p != null && !Minecraft.getInstance().isPaused()) {
                double maxIntensity = 0.0;
                HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                for (Map.Entry<BlockPos, Float> e : CACHED_POS.entrySet()) {
                    BlockPos pos = e.getKey();
                    maxIntensity = Math.max(maxIntensity, Rumbler.getIntensity(pos, (Player)p));
                    float duration = e.getValue().floatValue();
                    if ((duration -= (float)event.getPartialTick()) < 0.0f) {
                        toRemove.add(pos);
                        continue;
                    }
                    CACHED_POS.put(pos, Float.valueOf(duration));
                }
                toRemove.forEach(CACHED_POS::remove);
                if (maxIntensity != 0.0) {
                    event.setRoll((float)((double)event.getRoll() + (double)(Mth.sin((float)((float)(((double)animationCounter + event.getPartialTick()) / 3.0 % 1.0 * 2.0 * Math.PI))) * 1.5f) * maxIntensity));
                }
            }
        }
    }
}

