/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry.adapters;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.RegistrationContext;
import net.darkhax.bookshelf.common.api.registry.RegistryReference;
import net.darkhax.bookshelf.common.api.registry.adapters.RegistryAdapter;
import net.minecraft.resources.ResourceLocation;

public class GenericRegistryAdapter<V>
implements RegistryAdapter<ResourceLocation, V> {
    protected final RegistrationContext context;
    protected final BiConsumer<ResourceLocation, Supplier<V>> registryFunc;

    public GenericRegistryAdapter(RegistrationContext context, BiConsumer<ResourceLocation, Supplier<V>> registryFunc) {
        this.context = context;
        this.registryFunc = registryFunc;
    }

    public RegistryReference<ResourceLocation, V> add(ResourceLocation id, Supplier<V> value) {
        CachedSupplier<V> cache = CachedSupplier.cache(value);
        this.registryFunc.accept(id, cache);
        return RegistryReference.location(id, cache);
    }

    public RegistryReference<ResourceLocation, V> add(ResourceLocation id, V value) {
        return this.add(id, (V)((Supplier<Object>)() -> value));
    }

    @Override
    public RegistryReference<ResourceLocation, V> add(String key, Supplier<V> value) {
        return this.add(ResourceLocation.fromNamespaceAndPath((String)this.context.namespace(), (String)key), (V)value);
    }
}

