/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import net.minecraft.world.entity.player.Player;

public final class ExperienceHelper {
    public static boolean chargeExperiencePoints(Player player, int cost) {
        int playerExperience = ExperienceHelper.getExperiencePoints(player);
        if (playerExperience >= cost) {
            player.giveExperiencePoints(-cost);
            if (ExperienceHelper.getExperiencePoints(player) <= 0) {
                player.experienceProgress = 0.0f;
            }
            return true;
        }
        return false;
    }

    public static int getExperiencePoints(Player player) {
        int exp = ExperienceHelper.getTotalPointsForLevel(player.experienceLevel);
        exp = (int)((float)exp + player.experienceProgress * (float)ExperienceHelper.getTotalPointsForLevel(player.experienceLevel + 1));
        return exp;
    }

    public static int getPointForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 30) {
            return 112 + (level - 31) * 9;
        }
        if (level > 15) {
            return 37 + (level - 16) * 5;
        }
        return 7 + (level - 1) * 2;
    }

    public static int getPointsForLevel(int startingLevel, int targetLevel) {
        if (targetLevel < startingLevel) {
            throw new IllegalArgumentException("Starting level must be lower than the target level!");
        }
        if (startingLevel < 0) {
            throw new IllegalArgumentException("Level bounds must be positive!");
        }
        if (targetLevel == startingLevel) {
            return 0;
        }
        int requiredPoints = 0;
        for (int lvl = startingLevel + 1; lvl <= targetLevel; ++lvl) {
            requiredPoints += ExperienceHelper.getPointForLevel(lvl);
        }
        return requiredPoints;
    }

    public static int getTotalPointsForLevel(int level) {
        return ExperienceHelper.getPointsForLevel(0, level);
    }
}

