/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.amendments.common.entity.IVisualTransformationProvider;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public abstract class ThrownProjectile3DRenderer<E extends Entity>
extends EntityRenderer<E> {
    private final ResourceLocation texture;
    private final float scale;

    public ThrownProjectile3DRenderer(EntityRendererProvider.Context context, float scale, ResourceLocation texture) {
        super(context);
        this.scale = scale;
        this.texture = texture;
    }

    public void render(E entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (((Entity)entity).tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr(entity) < 12.25)) {
            super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
            poseStack.pushPose();
            poseStack.translate(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
            poseStack.scale(this.scale, this.scale, this.scale);
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f - Mth.rotLerp((float)partialTick, (float)((Entity)entity).yRotO, (float)entity.getYRot())));
            poseStack.mulPose(Axis.XN.rotationDegrees(-Mth.rotLerp((float)partialTick, (float)((Entity)entity).xRotO, (float)entity.getXRot())));
            if (entity instanceof IVisualTransformationProvider) {
                IVisualTransformationProvider vp = (IVisualTransformationProvider)entity;
                Matrix4f rotation = vp.amendments$getVisualTransformation(partialTick);
                poseStack.mulPose(rotation);
            }
            this.renderBall(entity, partialTick, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
    }

    public abstract void renderBall(E var1, float var2, PoseStack var3, MultiBufferSource var4, int var5);

    public ResourceLocation getTextureLocation(E entity) {
        return this.texture;
    }

    public static LayerDefinition createMesh(int size) {
        int r = size / 2;
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 0).addBox((float)(-r), (float)(-r), (float)(-r), (float)size, (float)size, (float)size), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("cube_emissive", CubeListBuilder.create().texOffs(32, 0).addBox((float)(-r), (float)(-r), (float)(-r), (float)size, (float)size, (float)size), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("overlay", CubeListBuilder.create().texOffs(0, size * 2).addBox((float)(-(r + 1)), (float)(-(r + 1)), (float)(-(r + 1)), (float)(size + 2), (float)(size + 2), (float)(size + 2)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

