/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionalCakeBlock
extends CakeBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape[] SHAPES_NORTH = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0)};
    protected static final VoxelShape[] SHAPES_SOUTH = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)13.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)11.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)9.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)5.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0)};
    protected static final VoxelShape[] SHAPES_EAST = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)9.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)15.0)};
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public final CakeRegistry.CakeType type;

    public DirectionalCakeBlock(CakeRegistry.CakeType type) {
        this(Utils.copyPropertySafe((Block)type.cake).dropsLike(type.cake), type);
    }

    public DirectionalCakeBlock(BlockBehaviour.Properties properties, CakeRegistry.CakeType type) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.WEST)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Direction d = DirectionalCakeBlock.getHitDir(player, hit);
        if (level.isClientSide) {
            if (this.eatSliceD((LevelAccessor)level, pos, state, player, d).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eatSliceD((LevelAccessor)level, pos, state, player, d);
    }

    public static Direction getHitDir(Player player, BlockHitResult hit) {
        return hit.getDirection().getAxis() != Direction.Axis.Y ? hit.getDirection() : player.getDirection().getOpposite();
    }

    public InteractionResult eatSliceD(LevelAccessor level, BlockPos pos, BlockState state, Player player, Direction dir) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        player.getFoodData().eat(2, 0.1f);
        if (!level.isClientSide()) {
            this.removeSlice(state, pos, level, player, dir);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void removeSlice(BlockState state, BlockPos pos, LevelAccessor level, Player player, Direction dir) {
        int i = (Integer)state.getValue((Property)BITES);
        if (i < 6) {
            if (i == 0 && CommonConfigs.DIRECTIONAL_CAKE.get().booleanValue()) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)dir);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.CAKE);
    }

    public MutableComponent getName() {
        return Blocks.CAKE.getName();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPES_EAST[(Integer)state.getValue((Property)BITES)];
            case Direction.SOUTH -> SHAPES_SOUTH[(Integer)state.getValue((Property)BITES)];
            case Direction.NORTH -> SHAPES_NORTH[(Integer)state.getValue((Property)BITES)];
            default -> SHAPE_BY_BITE[(Integer)state.getValue((Property)BITES)];
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.spawnCakeParticles(level, pos, rand);
        }
    }
}

