/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.AbstractCandleSkullBlock;
import net.mehvahdjukaar.amendments.common.tile.CandleSkullBlockTile;
import net.mehvahdjukaar.moonlight.api.block.IRecolorable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallCandleSkullBlock
extends AbstractCandleSkullBlock
implements IRecolorable {
    public static final MapCodec<WallCandleSkullBlock> CODEC = WallCandleSkullBlock.simpleCodec(WallCandleSkullBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final Map<Direction, VoxelShape[]> SHAPES = (Map)Util.make(() -> {
        HashMap<Direction, VoxelShape[]> m = new HashMap<Direction, VoxelShape[]>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            m.put(dir, new VoxelShape[]{MthUtils.rotateVoxelShape((VoxelShape)ONE_AABB.move(0.0, 0.0, 0.25), (Direction)dir), MthUtils.rotateVoxelShape((VoxelShape)TWO_AABB.move(0.0, 0.0, 0.25), (Direction)dir), MthUtils.rotateVoxelShape((VoxelShape)THREE_AABB.move(0.0, 0.0, 0.25), (Direction)dir), MthUtils.rotateVoxelShape((VoxelShape)FOUR_AABB.move(0.0, 0.0, 0.25), (Direction)dir)});
        }
        return m;
    });
    protected static final Map<Direction, Int2ObjectMap<List<Vec3>>> H_PARTICLE_OFFSETS = (Map)Util.make(() -> {
        Object2ObjectOpenHashMap temp = new Object2ObjectOpenHashMap(4);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            temp.put(dir, new Int2ObjectArrayMap(4));
            PARTICLE_OFFSETS.forEach((arg_0, arg_1) -> WallCandleSkullBlock.lambda$static$1(dir, (Map)temp, arg_0, arg_1));
        }
        return temp;
    });

    public WallCandleSkullBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends WallCandleSkullBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.getValue((Property)FACING))[(Integer)pState.getValue((Property)CANDLES) - 1];
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState pState) {
        return (Iterable)H_PARTICLE_OFFSETS.get(pState.getValue((Property)FACING)).get((Object)pState.getValue((Property)CANDLES));
    }

    public boolean tryRecolor(Level level, BlockPos blockPos, BlockState blockState, @Nullable DyeColor dyeColor) {
        Block otherCandle;
        CandleSkullBlockTile tile;
        BlockState c;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CandleSkullBlockTile && !(c = (tile = (CandleSkullBlockTile)blockEntity).getCandle()).isAir() && (otherCandle = BlocksColorAPI.changeColor((Block)c.getBlock(), (DyeColor)dyeColor)) != null && !c.is(otherCandle)) {
            tile.setCandle(otherCandle.withPropertiesOf(c));
            tile.setChanged();
            return true;
        }
        return false;
    }

    public boolean isDefaultColor(Level level, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            BlockState c = tile.getCandle();
            return BlocksColorAPI.isDefaultColor((Block)c.getBlock());
        }
        return false;
    }

    private static /* synthetic */ void lambda$static$1(Direction dir, Map temp, Integer key, List value) {
        ArrayList<Vec3> transformedList = new ArrayList<Vec3>();
        for (Vec3 v : value) {
            transformedList.add(MthUtils.rotateVec3((Vec3)new Vec3(v.x - 0.5, v.y, v.z + 0.25 - 0.5), (Direction)dir).add(0.5, 0.0, 0.5));
        }
        ((Int2ObjectMap)temp.get(dir)).put(key, transformedList);
    }
}

