/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import java.util.function.Predicate;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

class BellChainRing
implements BlockUse {
    BellChainRing() {
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.BELL_CHAIN_RINGING.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return block instanceof ChainBlock || CompatHandler.SUPPLEMENTARIES && SuppCompat.isRope(block);
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (stack.isEmpty() && hand == InteractionHand.MAIN_HAND) {
            Predicate<BlockState> predicate;
            Predicate<BlockState> predicate2 = predicate = state.getBlock() instanceof ChainBlock ? BellChainRing::isVerticalChain : BellChainRing::isRope;
            if (BellChainRing.findAndRingBell(world, pos, player, 0, predicate)) {
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean isRope(BlockState state) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.isRope(state.getBlock());
        }
        return false;
    }

    private static boolean isVerticalChain(BlockState s) {
        return s.getBlock() instanceof ChainBlock && s.getValue((Property)ChainBlock.AXIS) == Direction.Axis.Y;
    }

    public static boolean findAndRingBell(Level world, BlockPos pos, Player player, int it, Predicate<BlockState> predicate) {
        if (it > CommonConfigs.BELL_CHAIN_LENGTH.get()) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        Block b = state.getBlock();
        if (predicate.test(state)) {
            return BellChainRing.findAndRingBell(world, pos.above(), player, it + 1, predicate);
        }
        if (b instanceof BellBlock) {
            BellBlock bellBlock = (BellBlock)b;
            if (it != 0) {
                Direction d = (Direction)state.getValue((Property)BellBlock.FACING);
                BellAttachType att = (BellAttachType)state.getValue((Property)BellBlock.ATTACHMENT);
                if (att == BellAttachType.SINGLE_WALL || att == BellAttachType.DOUBLE_WALL || !Utils.getID((Block)b).getNamespace().equals("create")) {
                    d = d.getClockWise();
                }
                BlockHitResult hit = new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), d, pos, true);
                return bellBlock.onHit(world, state, hit, player, true);
            }
        }
        return false;
    }
}

