/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.SkibidiAnimations;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.GenericAnimationStuff;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.IRootModel;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class HatStandModel
extends HumanoidModel<HatStandEntity>
implements IRootModel {
    private final ModelPart basePlate;
    private final ModelPart neck;
    private final ModelPart neckJoint;
    private final ModelPart root;
    private final ModelPart dummyHead;

    public HatStandModel(ModelPart modelPart) {
        super(modelPart);
        this.basePlate = modelPart.getChild("base_plate");
        this.root = modelPart;
        this.neckJoint = modelPart.getChild("neck_joint");
        this.neck = this.neckJoint.getChild("neck");
        this.dummyHead = this.neckJoint.getChild("dummy_head");
        this.dummyHead.visible = false;
    }

    @Override
    public ModelPart getRoot() {
        return this.root;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public static LayerDefinition createMesh() {
        int f = 20;
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("base_plate", CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, 3.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.offset((float)0.0f, (float)f, (float)0.0f));
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)f, (float)0.0f));
        PartDefinition neck = partDefinition.addOrReplaceChild("neck_joint", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        neck.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.ZERO);
        neck.addOrReplaceChild("dummy_head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition createArmorMesh() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(HatStandEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Pose pose = entity.getPose();
        if (pose != Pose.STANDING) {
            GenericAnimationStuff.animate(this, entity.skibidiAnimation, SkibidiAnimations.DEFAULT, ageInTicks, 1.24f);
            this.dummyHead.y = this.dummyHead.y + (pose == Pose.SPIN_ATTACK ? 0.0f : 9.0f);
            this.dummyHead.visible = false;
        }
        Vector4f newPivot = new Vector4f(this.dummyHead.x, this.dummyHead.y, this.dummyHead.z, 1.0f);
        PoseStack poseStack = new PoseStack();
        this.translateAndRotate(this.neckJoint, poseStack);
        poseStack.last().pose().transform(newPivot);
        PartPose in = this.head.getInitialPose();
        this.head.offsetPos(new Vector3f(newPivot.x - in.x, newPivot.y - in.y, newPivot.z - in.z));
        this.head.setRotation(this.neckJoint.xRot + this.dummyHead.xRot, this.neckJoint.yRot + this.dummyHead.yRot, this.neckJoint.zRot + this.dummyHead.zRot);
        this.neck.yScale = -this.dummyHead.y / 3.0f;
    }

    public void prepareMobModel(HatStandEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.basePlate.visible = !entity.isNoBasePlate();
        this.basePlate.xRot = 0.0f;
        this.basePlate.yRot = (float)Math.PI / 180 * -Mth.rotLerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
        this.basePlate.zRot = 0.0f;
        float xAngle = (float)Math.PI / 180 * entity.getHeadPose().getX();
        this.head.yRot = (float)Math.PI / 180 * entity.getHeadPose().getY();
        float zAngle = (float)Math.PI / 180 * entity.getHeadPose().getZ();
        this.hat.copyFrom(this.head);
        zAngle += entity.swingAnimation.getAngle(partialTick) * ((float)Math.PI / 180);
        this.head.resetPose();
        this.neck.resetPose();
        this.neckJoint.resetPose();
        this.dummyHead.resetPose();
        this.neckJoint.y += 23.0f;
        this.neckJoint.zRot += zAngle;
        this.neckJoint.xRot += xAngle;
    }

    public void translateAndRotate(ModelPart modelPart, PoseStack poseStack) {
        poseStack.translate(modelPart.x, modelPart.y, modelPart.z);
        if (modelPart.xRot != 0.0f || modelPart.yRot != 0.0f || modelPart.zRot != 0.0f) {
            poseStack.mulPose(new Quaternionf().rotationZYX(modelPart.zRot, modelPart.yRot, modelPart.xRot));
        }
        if (modelPart.xScale != 1.0f || modelPart.yScale != 1.0f || modelPart.zScale != 1.0f) {
            poseStack.scale(modelPart.xScale, modelPart.yScale, modelPart.zScale);
        }
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.basePlate, (Object)this.neckJoint);
    }
}

