/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSelectMerchantTradePacket;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class RedMerchantScreen
extends AbstractContainerScreen<RedMerchantMenu> {
    private static final ResourceLocation TEXTURE = ModTextures.RED_MERCHANT_GUI_TEXTURE;
    private static final MutableComponent TRADE_OFFER = Component.translatable((String)"gui.supplementaries.orange_trader.trade");
    private static final MutableComponent I_RECEIVE = Component.translatable((String)"gui.supplementaries.orange_trader.get");
    private static final MutableComponent YOU_RECEIVE = Component.translatable((String)"gui.supplementaries.orange_trader.receive");
    private static final Component TRADES_LABEL = Component.translatable((String)"merchant.trades");
    private static final Component LEVEL_SEPARATOR = Component.literal((String)" - ");
    private static final Component DEPRECATED_TOOLTIP = Component.translatable((String)"merchant.deprecated");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;

    public RedMerchantScreen(RedMerchantMenu merchantMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)merchantMenu, inventory, component);
        this.imageWidth = 276;
        this.inventoryLabelX = 107;
    }

    private void postButtonClick() {
        ((RedMerchantMenu)this.menu).setSelectionHint(this.shopItem);
        ((RedMerchantMenu)this.menu).tryMoveItems(this.shopItem);
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSelectMerchantTradePacket(this.shopItem));
    }

    protected void init() {
        super.init();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        int k = j + 16 + 2;
        for (int l = 0; l < 7; ++l) {
            this.tradeOfferButtons[l] = (TradeOfferButton)this.addRenderableWidget((GuiEventListener)new TradeOfferButton(i + 5, k, l, button -> {
                if (button instanceof TradeOfferButton) {
                    TradeOfferButton b = (TradeOfferButton)button;
                    this.shopItem = b.getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            k += 20;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, k, l, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        MerchantOffers merchantOffers = ((RedMerchantMenu)this.menu).getOffers();
        if (!merchantOffers.isEmpty()) {
            int m = this.shopItem;
            if (m < 0 || m >= merchantOffers.size()) {
                return;
            }
            MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(m);
            if (merchantOffer.isOutOfStock()) {
                guiGraphics.blit(TEXTURE, this.leftPos + 83 + 99, this.topPos + 35, 0, 311.0f, 0.0f, 28, 21, 512, 256);
            }
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        int i = ((RedMerchantMenu)this.menu).getTraderLevel();
        if (i > 0 && i <= 5 && ((RedMerchantMenu)this.menu).showProgressBar()) {
            MutableComponent component = this.title.copy().append(LEVEL_SEPARATOR).append((Component)Component.translatable((String)("merchant.level." + i)));
            int j = this.font.width((FormattedText)component);
            int k = 49 + this.imageWidth / 2 - j / 2;
            graphics.drawString(this.font, (Component)component, k, 6, 0x404040);
        }
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        int l = this.font.width((FormattedText)TRADES_LABEL);
        graphics.drawString(this.font, TRADES_LABEL, (int)(5.0f - (float)l / 2.0f + 48.0f), 6, 0x404040, false);
        MutableComponent tradeOffer = TRADE_OFFER.withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.BOLD);
        graphics.drawString(this.font, (Component)tradeOffer, (int)(49.0f + (float)this.imageWidth / 2.0f - (float)this.font.width((FormattedText)tradeOffer) / 2.0f), 10, 0x404040);
        MutableComponent iReceive = I_RECEIVE.withStyle(ChatFormatting.WHITE);
        graphics.drawString(this.font, (Component)iReceive, (int)(20.0f + (float)this.imageWidth / 2.0f - (float)this.font.width((FormattedText)iReceive) / 2.0f), 24, 0x404040);
        MutableComponent uReceive = YOU_RECEIVE.withStyle(ChatFormatting.WHITE);
        graphics.drawString(this.font, (Component)uReceive, (int)(91.0f + (float)this.imageWidth / 2.0f - (float)this.font.width((FormattedText)uReceive) / 2.0f), 24, 0x404040);
    }

    private void renderProgressBar(GuiGraphics guiGraphics, int i, int j, MerchantOffer merchantOffer) {
        int k = ((RedMerchantMenu)this.menu).getTraderLevel();
        int l = ((RedMerchantMenu)this.menu).getTraderXp();
        if (k < 5) {
            guiGraphics.blit(TEXTURE, i + 136, j + 16, 0, 0.0f, 186.0f, 102, 5, 512, 256);
            int m = VillagerData.getMinXpPerLevel((int)k);
            if (l >= m && VillagerData.canLevelUp((int)k)) {
                float f = 100.0f / (float)(VillagerData.getMaxXpPerLevel((int)k) - m);
                int o = Math.min(Mth.floor((float)(f * (float)(l - m))), 100);
                guiGraphics.blit(TEXTURE, i + 136, j + 16, 0, 0.0f, 191.0f, o + 1, 5, 512, 256);
                int p = ((RedMerchantMenu)this.menu).getFutureTraderXp();
                if (p > 0) {
                    int q = Math.min(Mth.floor((float)((float)p * f)), 100 - o);
                    guiGraphics.blit(TEXTURE, i + 136 + o + 1, j + 16 + 1, 0, 2.0f, 182.0f, q, 3, 512, 256);
                }
            }
        }
    }

    private void renderScroller(GuiGraphics guiGraphics, int i, int j, MerchantOffers merchantOffers) {
        int k = merchantOffers.size() + 1 - 7;
        if (k > 1) {
            int l = 139 - (27 + (k - 1) * 139 / k);
            int m = 1 + l / k + 139 / k;
            int o = Math.min(113, this.scrollOff * m);
            if (this.scrollOff == k - 1) {
                o = 113;
            }
            guiGraphics.blit(TEXTURE, i + 94, j + 18 + o, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            guiGraphics.blit(TEXTURE, i + 94, j + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        MerchantOffers merchantOffers = ((RedMerchantMenu)this.menu).getOffers();
        if (!merchantOffers.isEmpty()) {
            MerchantOffer merchantOffer2;
            int k = this.leftPos;
            int l = this.topPos;
            int m = l + 16 + 1;
            int n = k + 5 + 5;
            this.renderScroller(guiGraphics, k, l, merchantOffers);
            int o = 0;
            for (MerchantOffer merchantOffer2 : merchantOffers) {
                if (!this.canScroll(merchantOffers.size()) || o >= this.scrollOff && o < 7 + this.scrollOff) {
                    ItemStack itemStack = merchantOffer2.getBaseCostA();
                    ItemStack itemStack2 = merchantOffer2.getCostA();
                    ItemStack itemStack3 = merchantOffer2.getCostB();
                    ItemStack itemStack4 = merchantOffer2.getResult();
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                    int p = m + 2;
                    this.renderAndDecorateCostA(guiGraphics, itemStack2, itemStack, n, p);
                    if (!itemStack3.isEmpty()) {
                        guiGraphics.renderFakeItem(itemStack3, k + 5 + 35, p);
                        guiGraphics.renderItemDecorations(this.font, itemStack3, k + 5 + 35, p);
                    }
                    this.renderButtonArrows(guiGraphics, merchantOffer2, k, p);
                    guiGraphics.renderFakeItem(itemStack4, k + 5 + 68, p);
                    guiGraphics.renderItemDecorations(this.font, itemStack4, k + 5 + 68, p);
                    guiGraphics.pose().popPose();
                    m += 20;
                }
                ++o;
            }
            int q = this.shopItem;
            merchantOffer2 = (MerchantOffer)merchantOffers.get(q);
            if (((RedMerchantMenu)this.menu).showProgressBar()) {
                this.renderProgressBar(guiGraphics, k, l, merchantOffer2);
            }
            if (merchantOffer2.isOutOfStock() && this.isHovering(186, 35, 22, 21, mouseX, mouseY) && ((RedMerchantMenu)this.menu).canRestock()) {
                guiGraphics.renderTooltip(this.font, DEPRECATED_TOOLTIP, mouseX, mouseY);
            }
            for (TradeOfferButton tradeOfferButton : this.tradeOfferButtons) {
                if (tradeOfferButton.isHoveredOrFocused()) {
                    tradeOfferButton.renderToolTip(guiGraphics, mouseX, mouseY);
                }
                tradeOfferButton.visible = tradeOfferButton.index < ((RedMerchantMenu)this.menu).getOffers().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderButtonArrows(GuiGraphics guiGraphics, MerchantOffer merchantOffer, int i, int j) {
        RenderSystem.enableBlend();
        if (merchantOffer.isOutOfStock()) {
            guiGraphics.blit(TEXTURE, i + 5 + 35 + 20, j + 3, 0, 25.0f, 171.0f, 10, 9, 512, 256);
        } else {
            guiGraphics.blit(TEXTURE, i + 5 + 35 + 20, j + 3, 0, 15.0f, 171.0f, 10, 9, 512, 256);
        }
    }

    private void renderAndDecorateCostA(GuiGraphics guiGraphics, ItemStack itemStack, ItemStack itemStack2, int i, int j) {
        guiGraphics.renderFakeItem(itemStack, i, j);
        if (itemStack2.getCount() == itemStack.getCount()) {
            guiGraphics.renderItemDecorations(this.font, itemStack, i, j);
        } else {
            guiGraphics.renderItemDecorations(this.font, itemStack2, i, j, itemStack2.getCount() == 1 ? "1" : null);
            guiGraphics.renderItemDecorations(this.font, itemStack, i + 14, j, itemStack.getCount() == 1 ? "1" : null);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
            guiGraphics.blit(TEXTURE, i + 7, j + 12, 0, 0.0f, 176.0f, 9, 2, 512, 256);
            guiGraphics.pose().popPose();
        }
    }

    private boolean canScroll(int numOffers) {
        return numOffers > 7;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = ((RedMerchantMenu)this.menu).getOffers().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.clamp((int)((int)((double)this.scrollOff - scrollY)), (int)0, (int)j);
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int i = ((RedMerchantMenu)this.menu).getOffers().size();
        if (this.isDragging) {
            int j = this.topPos + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.clamp((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        if (this.canScroll(((RedMerchantMenu)this.menu).getOffers().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int i, int j, int k, Button.OnPress onPress) {
            super(i, j, 88, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.index = k;
            this.visible = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
            if (this.isHovered && ((RedMerchantMenu)RedMerchantScreen.this.menu).getOffers().size() > this.index + RedMerchantScreen.this.scrollOff) {
                if (mouseX < this.getX() + 20) {
                    ItemStack itemStack = ((MerchantOffer)((RedMerchantMenu)RedMerchantScreen.this.menu).getOffers().get(this.index + RedMerchantScreen.this.scrollOff)).getCostA();
                    graphics.renderTooltip(RedMerchantScreen.this.font, itemStack, mouseX, mouseY);
                } else if (mouseX < this.getX() + 50 && mouseX > this.getX() + 30) {
                    ItemStack itemStack = ((MerchantOffer)((RedMerchantMenu)RedMerchantScreen.this.menu).getOffers().get(this.index + RedMerchantScreen.this.scrollOff)).getCostB();
                    if (!itemStack.isEmpty()) {
                        graphics.renderTooltip(RedMerchantScreen.this.font, itemStack, mouseX, mouseY);
                    }
                } else if (mouseX > this.getX() + 65) {
                    ItemStack itemStack = ((MerchantOffer)((RedMerchantMenu)RedMerchantScreen.this.menu).getOffers().get(this.index + RedMerchantScreen.this.scrollOff)).getResult();
                    graphics.renderTooltip(RedMerchantScreen.this.font, itemStack, mouseX, mouseY);
                }
            }
        }
    }
}

