/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.PaintingTooltip;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class PaintingTooltipComponent
implements ClientTooltipComponent {
    private final PaintingVariant pattern;
    private final int height;
    private final int width;

    public PaintingTooltipComponent(PaintingTooltip tooltip) {
        RegistryAccess ra = Minecraft.getInstance().level.registryAccess();
        DataResult painting = tooltip.data().read((DynamicOps)ra.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapDecoder)Painting.VARIANT_MAP_CODEC);
        this.pattern = (PaintingVariant)((Holder)painting.getOrThrow()).value();
        float h = this.pattern.height() * 16;
        float w = this.pattern.width() * 16;
        int size = ClientConfigs.Tweaks.TOOLTIP_IMAGE_SIZE.get();
        if (h > w) {
            this.height = size;
            this.width = (int)((float)size / h * w);
        } else {
            this.width = size;
            this.height = (int)((float)size / w * h);
        }
    }

    public int getHeight() {
        return this.height + 2;
    }

    public int getWidth(Font pFont) {
        return this.width;
    }

    public void renderImage(Font pFont, int x, int y, GuiGraphics graphics) {
        graphics.pose().pushPose();
        PaintingTextureManager paintingTextureManager = Minecraft.getInstance().getPaintingTextures();
        TextureAtlasSprite sprite = paintingTextureManager.get(this.pattern);
        RenderSystem.enableBlend();
        graphics.blit(x, y, 0, this.width, this.height, sprite);
        graphics.pose().popPose();
    }
}

