/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeBlock
extends AbstractRopeBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)Util.make((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    });

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Map<BlockState, VoxelShape> makeShapes() {
        HashMap<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
        VoxelShape down = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.box((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.box((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.box((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        VoxelShape knot = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        for (BlockState state : this.stateDefinition.getPossibleStates()) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) continue;
            VoxelShape v = Shapes.empty();
            if (((Boolean)state.getValue((Property)KNOT)).booleanValue()) {
                v = Shapes.or((VoxelShape)knot, (VoxelShape[])new VoxelShape[0]);
            }
            if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)up);
            }
            if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)north);
            }
            if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)south);
            }
            if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)west);
            }
            if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)east);
            }
            v = v.optimize();
            boolean flag = true;
            for (VoxelShape existing : shapes.values()) {
                if (!existing.equals(v)) continue;
                shapes.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            shapes.put(state, v);
        }
        return new Object2ObjectOpenHashMap(shapes);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @Override
    public boolean hasConnection(Direction dir, BlockState state) {
        return (Boolean)state.getValue((Property)FACING_TO_PROPERTY_MAP.get(dir));
    }

    @Override
    public BlockState setConnection(Direction dir, BlockState state, boolean value) {
        return (BlockState)state.setValue((Property)FACING_TO_PROPERTY_MAP.get(dir), (Comparable)Boolean.valueOf(value));
    }
}

