/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.fire_behaviors;

import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.IEntityInterceptFakeLevel;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TntBehavior
extends GenericProjectileBehavior {
    @Override
    @Nullable
    public Entity createEntity(ItemStack projectile, IEntityInterceptFakeLevel fakeLevel, Vec3 facing) {
        if (projectile.isEmpty()) {
            return null;
        }
        Item item = projectile.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            BlockState tntState = bi.getBlock().defaultBlockState();
            BlockPos pos = BlockPos.ZERO;
            Level level = (Level)fakeLevel;
            level.setBlock(pos, tntState, 4);
            TntBehavior.igniteTntHack(tntState, level, pos);
            Entity e = fakeLevel.getIntercepted();
            if (e != null) {
                e.setDeltaMovement(0.0, 1.0, 0.0);
            }
            return e;
        }
        return null;
    }

    public static boolean isTNTLikeBlock(BlockState tntState) {
        return tntState.is(ModTags.CANNON_TNTS) || tntState.getBlock() instanceof TntBlock;
    }

    public static void igniteTntHack(BlockState tntState, Level level, BlockPos pos) {
        Arrow dummyArrow = new Arrow(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, Items.ARROW.getDefaultInstance(), null);
        dummyArrow.setRemainingFireTicks(20);
        tntState.onProjectileHit(level, tntState, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, pos, true), (Projectile)dummyArrow);
    }
}

