/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.NoticeBoardContainerMenu;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CCCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.ExposureCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements Nameable,
IMapDisplay,
ITextHolderProvider {
    private final TextHolder textHolder;
    private boolean isWaxed = false;
    private int pageIndex = 0;
    private int maxPageIndex = 0;
    @Nullable
    private UUID playerWhoMayEdit;
    private Filterable<String> text = null;
    private float fontScale = 1.0f;
    private List<FormattedCharSequence> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;
    private Material cachedPattern = null;
    private boolean isNormalItem = false;

    public NoticeBoardBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.NOTICE_BOARD_TILE.get(), pos, state);
        this.textHolder = new TextHolder(1, 90);
    }

    public void updateTileOnInventoryChanged() {
        boolean shouldHaveBook = !this.getDisplayedItem().isEmpty();
        BlockState state = this.getBlockState();
        if ((Boolean)state.getValue((Property)BlockStateProperties.HAS_BOOK) != shouldHaveBook) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.HAS_BOOK, (Comparable)Boolean.valueOf(shouldHaveBook)), 2);
            if (shouldHaveBook) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.85f);
            } else {
                this.pageIndex = 0;
                this.maxPageIndex = 0;
                this.level.playSound(null, this.worldPosition, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.5f);
            }
        }
    }

    public float getPageProgress() {
        return this.maxPageIndex <= 0 ? 0.0f : (float)((int)((float)this.pageIndex / (float)this.maxPageIndex));
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public ItemStack getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        ItemStack itemstack = this.getDisplayedItem();
        Item item = itemstack.getItem();
        this.cachedPattern = null;
        if (item instanceof BannerPatternItem) {
            BannerPatternItem bannerPatternItem = (BannerPatternItem)item;
            this.cachedPattern = ModMaterials.getFlagMaterialForPatternItem(this.level, bannerPatternItem);
        }
        this.needsVisualRefresh = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
        this.updateText();
        this.isNormalItem = !NoticeBoardBlockTile.canPlaceInNoticeBoard(itemstack.getItem());
    }

    public boolean isNormalItem() {
        return this.isNormalItem;
    }

    public void updateText() {
        this.text = null;
        ItemStack itemstack = this.getDisplayedItem();
        WrittenBookContent written = (WrittenBookContent)itemstack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (written != null) {
            List pages = written.pages();
            if (!pages.isEmpty()) {
                if (this.pageIndex >= pages.size()) {
                    this.pageIndex %= pages.size();
                }
                this.maxPageIndex = pages.size() - 1;
                this.text = ((Filterable)pages.get(this.pageIndex)).map(Component::getString);
            }
            return;
        }
        WritableBookContent writable = (WritableBookContent)itemstack.get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (writable != null) {
            List pages = writable.pages();
            if (!pages.isEmpty()) {
                if (this.pageIndex >= pages.size()) {
                    this.pageIndex %= pages.size();
                }
                this.maxPageIndex = pages.size() - 1;
                this.text = (Filterable)pages.get(this.pageIndex);
            }
            return;
        }
        if (CompatHandler.EXPOSURE && ExposureCompat.isPictureItem(itemstack.getItem())) {
            this.maxPageIndex = ExposureCompat.getMaxPictureCount(itemstack);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.pageIndex = tag.getInt("PageNumber");
        this.textHolder.load(tag, registries, this.worldPosition);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("PageNumber", this.pageIndex);
        this.textHolder.save(tag, registries);
    }

    public AbstractContainerMenu createMenu(int id, Inventory player) {
        return new NoticeBoardContainerMenu(id, player, this);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isEmpty() && (CommonConfigs.Building.NOTICE_BOARDS_UNRESTRICTED.get() != false || NoticeBoardBlockTile.canPlaceInNoticeBoard(stack.getItem()));
    }

    private static boolean canPlaceInNoticeBoard(Item item) {
        return item.builtInRegistryHolder().is(ItemTags.LECTERN_BOOKS) || item instanceof MapItem || item instanceof BannerPatternItem || CompatHandler.EXPOSURE && ExposureCompat.isPictureItem(item) || CompatHandler.COMPUTERCRAFT && CCCompat.isPrintedBook(item);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean shouldSkipTileRenderer() {
        return (Boolean)this.getBlockState().getValue((Property)NoticeBoardBlock.CULLED) != false || (Boolean)this.getBlockState().getValue((Property)NoticeBoardBlock.HAS_BOOK) == false;
    }

    public Material getCachedPattern() {
        return this.cachedPattern;
    }

    @Nullable
    public Filterable<String> getText() {
        return this.text;
    }

    public DyeColor getDyeColor() {
        return this.textHolder.getColor();
    }

    public boolean isGlowing() {
        return this.textHolder.hasGlowingText();
    }

    public boolean hasAntiqueInk() {
        return this.textHolder.supplementaries$isAntique();
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<FormattedCharSequence> l) {
        this.cachedPageLines = l;
    }

    public List<FormattedCharSequence> getCachedLines() {
        return this.cachedPageLines;
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)NoticeBoardBlock.FACING);
    }

    public void turnPage() {
        ++this.pageIndex;
        this.level.playSound(null, this.worldPosition, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 1.45f);
        this.setChanged();
    }

    public ItemInteractionResult interact(Player player, InteractionHand handIn, BlockHitResult hit, ItemStack stack) {
        ItemInteractionResult res;
        Level level = player.level();
        BlockState state = this.getBlockState();
        if (player.isShiftKeyDown() && !this.isEmpty() && player.getItemInHand(handIn).isEmpty()) {
            ItemStack it = this.removeItemNoUpdate(0);
            BlockPos newPos = this.worldPosition.offset(((Direction)state.getValue((Property)NoticeBoardBlock.FACING)).getNormal());
            ItemEntity drop = new ItemEntity(level, (double)newPos.getX() + 0.5, (double)newPos.getY() + 0.5, (double)newPos.getZ() + 0.5, it);
            drop.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)drop);
            this.setChanged();
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        Direction face = hit.getDirection();
        if (face == state.getValue((Property)NoticeBoardBlock.FACING) && (res = super.interactWithPlayerItem(player, handIn, stack)).consumesAction()) {
            return res;
        }
        ItemInteractionResult r = this.textHolderInteract((BlockEntity)this, 0, player, handIn, stack, face, hit.getLocation());
        if (r != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return r;
        }
        if (!CommonConfigs.Building.NOTICE_BOARD_GUI.get().booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.tryOpeningTextEditGui((BlockEntity)this, sp, player.getItemInHand(handIn), face, hit.getLocation());
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void setCurrentUser(@Nullable UUID uuid) {
        this.playerWhoMayEdit = uuid;
    }

    public UUID getCurrentUser() {
        return this.playerWhoMayEdit;
    }

    @Override
    public TextHolder getTextHolder(int ind) {
        return this.textHolder;
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setWaxed(boolean b) {
        this.isWaxed = b;
    }
}

