/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.controllers;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoatMoveController
extends MoveControl {
    public BoatMoveController(Mob mob) {
        super(mob);
    }

    private boolean isWalkableWithBoat(float relativeX, float relativeZ) {
        PathNavigation pathNavigation = this.mob.getNavigation();
        NodeEvaluator nodeEvaluator = pathNavigation.getNodeEvaluator();
        return nodeEvaluator.getPathType(this.mob, BlockPos.containing((double)(this.mob.getX() + (double)relativeX), (double)this.mob.getBlockY(), (double)(this.mob.getZ() + (double)relativeZ))) == PathType.WALKABLE;
    }

    @Nullable
    private Boat getBoat() {
        Entity vehicle = this.mob.getVehicle();
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            return boat;
        }
        return null;
    }

    public void tick() {
        Boat boat = this.getBoat();
        if (boat == null) {
            super.tick();
            return;
        }
        if (this.operation == MoveControl.Operation.STRAFE) {
            float z;
            float moveSpeedMod = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float actualSpeed = (float)this.speedModifier * moveSpeedMod;
            float forward = this.strafeForwards;
            float right = this.strafeRight;
            float len = Mth.sqrt((float)(forward * forward + right * right));
            if (len < 1.0f) {
                len = 1.0f;
            }
            len = actualSpeed / len;
            float sin = Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            float cos = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            float x = (forward *= len) * cos - (right *= len) * sin;
            if (!this.isWalkableWithBoat(x, z = right * cos + forward * sin)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(actualSpeed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            double distX = this.wantedX - this.mob.getX();
            double distZ = this.wantedZ - this.mob.getZ();
            double distY = this.wantedY - this.mob.getY();
            double lenSq = distX * distX + distY * distY + distZ * distZ;
            if (lenSq < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
                return;
            }
            float angle = (float)(Mth.atan2((double)distZ, (double)distX) * 57.2957763671875) - 90.0f;
            this.controlBoat(boat, angle);
        } else {
            this.mob.setZza(0.0f);
        }
    }

    private void controlBoat(Boat boat, float wantedAngle) {
        Vec3 bH;
        Vec3 aH;
        double side;
        if (!boat.isVehicle()) {
            return;
        }
        float amount = 0.0f;
        boat.setYRot(this.rotlerp(boat.getYRot(), wantedAngle, 90.0f));
        double speed = this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
        float moveAmount = (float)(speed / (double)0.1f * (double)0.04f);
        float scalar = 0.25f;
        Vec3 oldMovement = boat.getDeltaMovement();
        Vec3 newDirection = new Vec3((double)(Mth.sin((float)(-boat.getYRot() * ((float)Math.PI / 180))) * (amount += moveAmount * scalar)), 0.0, (double)(Mth.cos((float)(boat.getYRot() * ((float)Math.PI / 180))) * amount));
        boat.setDeltaMovement(oldMovement.add(newDirection));
        Vec3 oldDir = oldMovement.normalize();
        Vec3 newDir = newDirection.normalize();
        double dot = oldDir.dot(newDir);
        if (Math.abs(dot) > 0.7) {
            boat.setPaddleState(true, true);
        }
        if ((side = (aH = new Vec3(oldDir.x, 0.0, oldDir.z).normalize()).cross(bH = new Vec3(newDir.x, 0.0, newDir.z).normalize()).dot(new Vec3(0.0, 1.0, 0.0))) > 0.0) {
            boat.setPaddleState(true, false);
        } else {
            boat.setPaddleState(false, true);
        }
    }
}

