/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.EnumSet;
import java.util.List;
import net.mehvahdjukaar.supplementaries.mixins.EntityAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.vehicle.Boat;

public class BoardBoatGoal
extends Goal {
    private final int tryInterval;
    private final Mob mob;
    private final int maxGoalTickTime = 400;
    private final int speedModifier;
    private int goalTick;
    private Boat boat;

    public BoardBoatGoal(Mob mob, int speedMod, int tryInterval) {
        this.mob = mob;
        this.speedModifier = speedMod;
        this.tryInterval = tryInterval;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private Boat getFreeBoat() {
        List list = this.mob.level().getEntitiesOfClass(Boat.class, this.mob.getBoundingBox().inflate(8.0), this::hasFreeSeat);
        Boat nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Boat boat : list) {
            double distance = this.mob.distanceToSqr((Entity)boat);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = boat;
        }
        return nearest;
    }

    private boolean hasFreeSeat(Boat boat) {
        if (boat instanceof EntityAccessor) {
            EntityAccessor ea = (EntityAccessor)boat;
            Mob mob = this.mob;
            if (mob instanceof EntityAccessor) {
                EntityAccessor em = (EntityAccessor)mob;
                return ea.invokeCanAddPassenger((Entity)this.mob) && em.invokeCanRide((Entity)boat);
            }
        }
        return true;
    }

    public boolean canUse() {
        boolean selfOrTargetInWater;
        LivingEntity target = this.mob.getTarget();
        boolean bl = selfOrTargetInWater = this.mob.isInWater() || target != null && target.isInWater();
        if (target != null && !selfOrTargetInWater) {
            return false;
        }
        if (this.mob.getVehicle() == null && this.mob.getRandom().nextInt(this.tryInterval) == 0) {
            this.boat = this.getFreeBoat();
            return this.boat != null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.mob.getVehicle() == null && this.goalTick < this.maxGoalTickTime && this.boat != null && this.boat.isAlive() && this.hasFreeSeat(this.boat);
    }

    public void start() {
        this.mob.getLookControl().setLookAt((Entity)this.boat);
        this.mob.getNavigation().moveTo((Entity)this.boat, (double)this.speedModifier);
    }

    public void stop() {
        this.boat = null;
        this.goalTick = 0;
    }

    public void tick() {
        ++this.goalTick;
        if (this.mob.closerThan((Entity)this.boat, (double)(this.boat.getBbWidth() / 2.0f + this.mob.getBbWidth() / 2.0f))) {
            this.mob.startRiding((Entity)this.boat);
            this.boat = null;
        } else if (this.goalTick % 40 == 0) {
            this.mob.getNavigation().moveTo((Entity)this.boat, (double)this.speedModifier);
        }
    }
}

