/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.mehvahdjukaar.supplementaries.common.entities.goals.PlundererAICommon;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.raid.Raider;

public class UseCannonBoatBehavior
extends Behavior<LivingEntity> {
    private int attackDelay;
    private CannonAccess access;

    public UseCannonBoatBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.LAST_WOKEN, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity owner) {
        Entity boat = owner.getControlledVehicle();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            return cb.getInternalCannon().hasSomeFuelAndProjectiles();
        }
        LivingEntity livingentity = UseCannonBoatBehavior.getAttackTarget(owner);
        return BehaviorUtils.canSee((LivingEntity)owner, (LivingEntity)livingentity);
    }

    private static LivingEntity getAttackTarget(LivingEntity shooter) {
        return (LivingEntity)shooter.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    protected boolean canStillUse(ServerLevel level, LivingEntity owner, long gameTime) {
        Entity boat = owner.getControlledVehicle();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            return cb.getInternalCannon().hasSomeFuelAndProjectiles();
        }
        return false;
    }

    protected void start(ServerLevel level, LivingEntity owner, long gameTime) {
        Entity boat = owner.getControlledVehicle();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            this.access = cb;
        }
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void stop(ServerLevel level, LivingEntity entity, long gameTime) {
        this.access = null;
    }

    protected void tick(ServerLevel level, LivingEntity owner, long gameTime) {
        LivingEntity livingentity = UseCannonBoatBehavior.getAttackTarget(owner);
        this.lookAtTarget(owner, livingentity);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (PlundererAICommon.aimCannonAndShoot(this.access, (Mob)((Raider)owner), livingentity, this.attackDelay <= 0)) {
            this.attackDelay = Mth.randomBetweenInclusive((RandomSource)level.random, (int)50, (int)80);
        }
    }

    private void lookAtTarget(LivingEntity shooter, LivingEntity target) {
        shooter.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
    }
}

