/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ItemLoreRecipe
extends CustomRecipe {
    private final boolean setLore;
    private final Ingredient requiredIngredient;

    public ItemLoreRecipe(CraftingBookCategory category, Ingredient ingredient, boolean setLore) {
        super(category);
        this.requiredIngredient = ingredient;
        this.setLore = setLore;
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack nameTag = null;
        ItemStack item = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.requiredIngredient.test(stack) && (!this.setLore || stack.has(DataComponents.CUSTOM_NAME))) {
                if (nameTag != null) {
                    return false;
                }
                nameTag = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            if (item != null) {
                return false;
            }
            item = stack;
        }
        return nameTag != null && item != null && (this.setLore || !((ItemLore)item.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY)).lines().isEmpty());
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack nameTag = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.requiredIngredient.test(stack)) {
                nameTag = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            itemstack = stack;
        }
        ItemStack result = itemstack.copyWithCount(1);
        if (!this.setLore) {
            result.remove(DataComponents.LORE);
        } else {
            Component lore = nameTag.getHoverName();
            result.set(DataComponents.LORE, (Object)new ItemLore(List.of(lore)));
        }
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList stacks = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (!itemstack.is(Items.NAME_TAG)) continue;
            ItemStack copy = itemstack.copy();
            copy.setCount(1);
            stacks.set(i, (Object)copy);
            return stacks;
        }
        return stacks;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ITEM_LORE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ItemLoreRecipe> {
        private static final MapCodec<ItemLoreRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.requiredIngredient), (App)Codec.BOOL.fieldOf("set_lore").forGetter(recipe -> recipe.setLore)).apply((Applicative)instance, ItemLoreRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemLoreRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.requiredIngredient, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.setLore, ItemLoreRecipe::new);

        public MapCodec<ItemLoreRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemLoreRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

