/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BombExplosion {
    public static Explosion createExplosion(Entity source, ServerLevel level, double x, double y, double z, BombEntity.BombType type, boolean breaksBlocks) {
        Level.ExplosionInteraction interaction = breaksBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.TRIGGER;
        DamageSource damageSource = BombExplosion.getBombDamageSource(source);
        BombExplosionDamageCalculator damageCalculator = new BombExplosionDamageCalculator(type);
        NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)source, (CustomPacketPayload)new ClientBoundParticlePacket(new Vec3(x, y, z), ClientBoundParticlePacket.Kind.BOMB_EXPLOSION, (int)type.getRadius()));
        return level.explode(source, damageSource, (ExplosionDamageCalculator)damageCalculator, x, y, z, (float)type.getRadius(), false, interaction, (ParticleOptions)ModParticles.BOMB_EXPLOSION_PARTICLE.get(), (ParticleOptions)ModParticles.BOMB_EXPLOSION_PARTICLE.get(), ModSounds.BOMB_EXPLOSION.getHolder());
    }

    @NotNull
    private static DamageSource getBombDamageSource(Entity source) {
        return ModDamageSources.bombExplosion(source.level(), source, (Entity)Explosion.getIndirectSourceEntityInternal((Entity)source));
    }

    private static class BombExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        private final BombEntity.BombType type;

        public BombExplosionDamageCalculator(BombEntity.BombType type) {
            this.type = type;
        }

        public boolean shouldBlockExplode(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
            return switch (this.type.breakMode()) {
                case BombEntity.BreakingMode.ALL -> true;
                case BombEntity.BreakingMode.WEAK -> {
                    if (state.canBeReplaced((Fluid)Fluids.WATER) || state.is(ModTags.BOMB_BREAKABLE) || state.getBlock() instanceof TntBlock) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }
}

